/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.DAMLDatatype;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLOntology;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLDatatypePropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLListImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLLoader;
import com.hp.hpl.jena.ontology.daml.impl.DAMLObjectPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLOntologyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLRestrictionImpl;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;

public class DAMLModelImpl
extends OntModelImpl
implements DAMLModel {
    protected static Object[][] DAML_CLASS_TABLE = new Object[][]{{DAML_OIL.Class, DAMLClassImpl.class}, {RDFS.Class, DAMLClassImpl.class}, {DAML_OIL.Restriction, DAMLRestrictionImpl.class}, {DAML_OIL.List, DAMLListImpl.class}, {DAML_OIL.Ontology, DAMLOntologyImpl.class}, {DAML_OIL.Property, DAMLPropertyImpl.class}, {RDF.Property, DAMLPropertyImpl.class}, {DAML_OIL.DatatypeProperty, DAMLDatatypePropertyImpl.class}, {DAML_OIL.ObjectProperty, DAMLObjectPropertyImpl.class}, {DAML_OIL.UniqueProperty, DAMLPropertyImpl.class}, {DAML_OIL.TransitiveProperty, DAMLObjectPropertyImpl.class}, {DAML_OIL.UnambiguousProperty, DAMLObjectPropertyImpl.class}};
    private DAMLLoader m_loader = new DAMLLoader(this);

    public DAMLModelImpl(OntModelSpec ontModelSpec, Model model) {
        super(ontModelSpec, model);
        this.initStore();
    }

    public DAMLOntology createDAMLOntology(String string) {
        return (DAMLOntology)this.createOntResource(DAMLOntology.class, this.getProfile().ONTOLOGY(), string);
    }

    public DAMLInstance createDAMLInstance(DAMLClass dAMLClass, String string) {
        return (DAMLInstance)this.createOntResource(DAMLInstance.class, dAMLClass, string);
    }

    public DAMLDataInstance createDAMLDataInstance(Resource resource, Object object) {
        return this.createDAMLDataInstance(TypeMapper.getInstance().getTypeByName(resource.getURI()), object);
    }

    public DAMLDataInstance createDAMLDataInstance(RDFDatatype rDFDatatype, Object object) {
        Resource resource = this.createResource(this.getResource(rDFDatatype.getURI()));
        resource.addProperty(RDF.value, this.createTypedLiteral(object, rDFDatatype));
        return (DAMLDataInstance)resource.as(DAMLDataInstance.class);
    }

    public DAMLDataInstance createDAMLDataInstance(Object object) {
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByValue(object);
        if (rDFDatatype == null) {
            throw new JenaException("Could not determine an appropriate datatype for value " + object);
        }
        return this.createDAMLDataInstance(rDFDatatype, object);
    }

    public DAMLClass createDAMLClass(String string) {
        return (DAMLClass)this.createOntResource(DAMLClass.class, this.getProfile().CLASS(), string);
    }

    public DAMLProperty createDAMLProperty(String string) {
        return (DAMLProperty)this.createOntResource(DAMLProperty.class, this.getProfile().PROPERTY(), string);
    }

    public DAMLObjectProperty createDAMLObjectProperty(String string) {
        return (DAMLObjectProperty)this.createOntResource(DAMLObjectProperty.class, this.getProfile().OBJECT_PROPERTY(), string);
    }

    public DAMLDatatypeProperty createDAMLDatatypeProperty(String string) {
        return (DAMLDatatypeProperty)this.createOntResource(DAMLDatatypeProperty.class, this.getProfile().DATATYPE_PROPERTY(), string);
    }

    public DAMLList createDAMLList() {
        return (DAMLList)this.getResource(DAML_OIL.nil.getURI()).as(DAMLList.class);
    }

    public DAMLList createDAMLList(Iterator iterator) {
        DAMLList dAMLList = this.createDAMLList();
        if (iterator.hasNext()) {
            RDFNode rDFNode = (RDFNode)iterator.next();
            dAMLList = (DAMLList)dAMLList.cons(rDFNode);
            while (iterator.hasNext()) {
                dAMLList.add((RDFNode)iterator.next());
            }
        }
        return dAMLList;
    }

    public DAMLList createDAMLList(RDFNode[] rDFNodeArray) {
        return this.createDAMLList(Arrays.asList(rDFNodeArray).iterator());
    }

    public DAMLRestriction createDAMLRestriction(String string) {
        return (DAMLRestriction)this.createOntResource(DAMLRestriction.class, this.getProfile().RESTRICTION(), string);
    }

    public DAMLDatatype createDAMLDatatype(String string) {
        Resource resource = this.getResource(string);
        resource.addProperty(RDF.type, DAML_OIL.Datatype);
        return (DAMLDatatype)resource.as(DAMLDatatype.class);
    }

    public DAMLCommon createDAMLValue(String string, Resource resource) {
        Class clazz = DAMLInstance.class;
        for (int i = 0; i < DAML_CLASS_TABLE.length; ++i) {
            if (!DAML_CLASS_TABLE[i][0].equals(resource)) continue;
            clazz = (Class)DAML_CLASS_TABLE[i][1];
            break;
        }
        return (DAMLCommon)this.createOntResource(clazz, resource, string);
    }

    public DAMLCommon getDAMLValue(String string) {
        return this.containsResource(string) ? (DAMLCommon)this.getResource(string).as(DAMLCommon.class) : null;
    }

    public DAMLCommon getDAMLValue(String string, DAMLClass dAMLClass) {
        DAMLCommon dAMLCommon = this.getDAMLValue(string);
        return dAMLCommon == null && dAMLClass != null ? this.createDAMLValue(string, dAMLClass) : dAMLCommon;
    }

    public ExtendedIterator listDAMLClasses() {
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().CLASS(), null, DAMLClass.class));
    }

    public ExtendedIterator listDAMLProperties() {
        return UniqueExtendedIterator.create(this.findByTypeAs(this.getProfile().PROPERTY(), null, DAMLProperty.class));
    }

    public ExtendedIterator listDAMLInstances() {
        return UniqueExtendedIterator.create(this.listIndividuals().mapWith(new Map1(){

            public Object map1(Object object) {
                return ((Resource)object).as(class$com$hp$hpl$jena$ontology$daml$DAMLInstance == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLInstance = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLInstance")) : class$com$hp$hpl$jena$ontology$daml$DAMLInstance);
            }
        }));
    }

    public DAMLClass getDAMLClass(String string) {
        return this.containsResource(string) ? (DAMLClass)this.getResource(string).as(DAMLClass.class) : null;
    }

    public DAMLProperty getDAMLProperty(String string) {
        return this.containsResource(string) ? (DAMLProperty)this.getResource(string).as(DAMLProperty.class) : null;
    }

    public DAMLInstance getDAMLInstance(String string) {
        return this.containsResource(string) ? (DAMLInstance)this.getResource(string).as(DAMLInstance.class) : null;
    }

    public Model read(String string, String string2, String string3) {
        try {
            URL uRL = new URL(string);
            return this.read(uRL.openStream(), string2, string3);
        }
        catch (IOException iOException) {
            throw new OntologyException("I/O error while reading from uri " + string);
        }
    }

    public DAMLLoader getLoader() {
        return this.m_loader;
    }

    public boolean getLoadSuccessful() {
        return this.getLoader().getStatus() == 0L;
    }

    public TypeMapper getDatatypeRegistry() {
        return TypeMapper.getInstance();
    }

    public void setUseEquivalence(boolean bl) {
    }

    public boolean getUseEquivalence() {
        return true;
    }

    protected void initStore() {
    }

    protected boolean containsResource(String string) {
        Resource resource = this.getResource(string);
        StmtIterator stmtIterator = this.listStatements(resource, null, (RDFNode)null);
        if (stmtIterator.hasNext()) {
            stmtIterator.close();
            return true;
        }
        stmtIterator.close();
        StmtIterator stmtIterator2 = this.listStatements(null, null, resource);
        if (stmtIterator2.hasNext()) {
            stmtIterator2.close();
            return true;
        }
        stmtIterator2.close();
        Property property = this.getProperty(string);
        StmtIterator stmtIterator3 = this.listStatements(null, property, (RDFNode)null);
        if (stmtIterator3.hasNext()) {
            stmtIterator3.close();
            return true;
        }
        stmtIterator3.close();
        return false;
    }
}

