/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.ontology.daml.impl.VocabularyManager;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;

public class DAMLClassImpl
extends OntClassImpl
implements DAMLClass {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLClassImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLClass");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Profile profile;
            Profile profile2 = profile = enhGraph instanceof OntModel ? ((OntModel)((Object)enhGraph)).getProfile() : null;
            return profile != null && profile.isSupported(node, enhGraph, class$com$hp$hpl$jena$ontology$daml$DAMLClass == null ? (class$com$hp$hpl$jena$ontology$daml$DAMLClass = DAMLClassImpl.class$("com.hp.hpl.jena.ontology.daml.DAMLClass")) : class$com$hp$hpl$jena$ontology$daml$DAMLClass);
        }
    };
    private PropertyAccessor m_propSubClassOf = new PropertyAccessorImpl(this.getProfile().SUB_CLASS_OF(), this);
    private PropertyAccessor m_propDisjointWith = new PropertyAccessorImpl(this.getProfile().DISJOINT_WITH(), this);
    private PropertyAccessor m_propDisjointUnionOf = new PropertyAccessorImpl(DAML_OIL.disjointUnionOf, this);
    private PropertyAccessor m_propSameClassAs = new PropertyAccessorImpl(this.getProfile().EQUIVALENT_CLASS(), this);
    private PropertyAccessor m_propOneOf = new PropertyAccessorImpl(this.getProfile().ONE_OF(), this);
    private PropertyAccessor m_propUnionOf = new PropertyAccessorImpl(this.getProfile().UNION_OF(), this);
    private PropertyAccessor m_propIntersectionOf = new PropertyAccessorImpl(this.getProfile().INTERSECTION_OF(), this);
    private PropertyAccessor m_propComplementOf = new PropertyAccessorImpl(this.getProfile().COMPLEMENT_OF(), this);
    protected DAMLCommon m_common = null;
    protected DAMLVocabulary m_vocabulary = VocabularyManager.getDefaultVocabulary();

    public DAMLClassImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
        this.m_common = new DAMLCommonImpl(node, enhGraph);
    }

    public void setRDFType(Resource resource, boolean bl) {
        this.m_common.setRDFType(resource, bl);
    }

    public DAMLModel getDAMLModel() {
        return this.m_common.getDAMLModel();
    }

    public ExtendedIterator getRDFTypes(boolean bl) {
        return this.m_common.getRDFTypes(bl);
    }

    public DAMLVocabulary getVocabulary() {
        return this.m_vocabulary;
    }

    public LiteralAccessor prop_label() {
        return this.m_common.prop_label();
    }

    public LiteralAccessor prop_comment() {
        return this.m_common.prop_comment();
    }

    public PropertyAccessor prop_equivalentTo() {
        return this.m_common.prop_equivalentTo();
    }

    public PropertyAccessor prop_type() {
        return this.m_common.prop_type();
    }

    public ExtendedIterator getEquivalentValues() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.m_common.getEquivalentValues(), this.getSameClasses());
        return UniqueExtendedIterator.create(concatenatedIterator).mapWith(new OntResourceImpl.AsMapper(this, DAMLClass.class));
    }

    public ExtendedIterator getEquivalenceSet() {
        HashSet<DAMLClassImpl> hashSet = new HashSet<DAMLClassImpl>();
        hashSet.add(this);
        ExtendedIterator extendedIterator = this.getEquivalentValues();
        while (extendedIterator.hasNext()) {
            hashSet.add((DAMLClassImpl)extendedIterator.next());
        }
        hashSet.remove(this);
        return WrappedIterator.create(hashSet.iterator());
    }

    public PropertyAccessor prop_subClassOf() {
        return this.m_propSubClassOf;
    }

    public PropertyAccessor prop_disjointWith() {
        return this.m_propDisjointWith;
    }

    public PropertyAccessor prop_disjointUnionOf() {
        return this.m_propDisjointUnionOf;
    }

    public PropertyAccessor prop_sameClassAs() {
        return this.m_propSameClassAs;
    }

    public PropertyAccessor prop_unionOf() {
        return this.m_propUnionOf;
    }

    public PropertyAccessor prop_intersectionOf() {
        return this.m_propIntersectionOf;
    }

    public PropertyAccessor prop_complementOf() {
        return this.m_propComplementOf;
    }

    public PropertyAccessor prop_oneOf() {
        return this.m_propOneOf;
    }

    public boolean isEnumeration() {
        return this.hasProperty(this.getVocabulary().oneOf());
    }

    public boolean isNamedClass() {
        return !this.isAnon();
    }

    public boolean isRestriction() {
        return this.hasProperty(RDF.type, this.getProfile().RESTRICTION());
    }

    public boolean isIntersection() {
        return this.hasProperty(this.getVocabulary().intersectionOf());
    }

    public boolean isUnion() {
        return this.hasProperty(this.getVocabulary().unionOf());
    }

    public boolean isDisjointUnion() {
        return this.hasProperty(this.getVocabulary().disjointUnionOf());
    }

    public boolean isComplement() {
        return this.hasProperty(this.getVocabulary().complementOf());
    }

    public ExtendedIterator getSubClasses() {
        return this.getSubClasses(true);
    }

    public ExtendedIterator getSubClasses(boolean bl) {
        return WrappedIterator.create(super.listSubClasses(!bl)).mapWith(new OntResourceImpl.AsMapper(this, DAMLClass.class));
    }

    public ExtendedIterator getSuperClasses() {
        return this.getSuperClasses(true);
    }

    public ExtendedIterator getSuperClasses(boolean bl) {
        return WrappedIterator.create(super.listSuperClasses(!bl)).mapWith(new OntResourceImpl.AsMapper(this, DAMLClass.class));
    }

    public ExtendedIterator getSameClasses() {
        return WrappedIterator.create(super.listEquivalentClasses()).mapWith(new OntResourceImpl.AsMapper(this, DAMLClass.class));
    }

    public ExtendedIterator getInstances() {
        return WrappedIterator.create(this.listInstances()).mapWith(new OntResourceImpl.AsMapper(this, DAMLInstance.class));
    }

    public ExtendedIterator getDefinedProperties() {
        return this.getDefinedProperties(true);
    }

    public ExtendedIterator getDefinedProperties(boolean bl) {
        return WrappedIterator.create(this.listDeclaredProperties(bl)).mapWith(new OntResourceImpl.AsMapper(this, DAMLProperty.class));
    }
}

