/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.AntlrUtils;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Exception;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class N3toRDF
implements N3ParserEventHandler {
    protected static Log logger = LogFactory.getLog((Class)N3toRDF.class);
    public static boolean VERBOSE = false;
    Model model;
    Map resourceRef = new HashMap();
    Map propertyRef = new HashMap();
    Map myPrefixMapping = new HashMap();
    boolean allowPropertySymbols = true;
    boolean allowKeywordA = true;
    static final String NS_rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String NS_rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    static final String LOG_IMPLIES = "http://www.w3.org/2000/10/swap/log#implies";
    static final String LOG_MEANS = "http://www.w3.org/2000/10/swap/log#means";
    static final String XMLLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private String base = null;
    private String basedir = null;
    final String anonPrefix = "_";
    private Map bNodeMap = new HashMap();

    N3toRDF() {
    }

    public void setBase(String string) {
        int n;
        if (string == null) {
            this.base = null;
            this.basedir = null;
            return;
        }
        this.base = string;
        this.basedir = this.base.startsWith("file:") ? ((n = this.base.lastIndexOf(47)) >= 0 ? this.base.substring(0, n + 1) : this.base) : this.base;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void error(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void error(String string) {
        this.error(null, string);
    }

    public void warning(Exception exception, String string) {
        logger.warn((Object)string, (Throwable)exception);
    }

    public void warning(String string) {
        logger.warn((Object)string);
    }

    public void deprecated(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void deprecated(String string) {
        this.deprecated(null, string);
    }

    public void startFormula(int n, String string) {
        this.error("Line " + n + ": N3toRDF: All statements are asserted - no formulae in RDF");
    }

    public void endFormula(int n, String string) {
    }

    public void directive(int n, AST aST, AST[] aSTArray, String string) {
        if (aST.getType() == 19) {
            if (aSTArray[0].getType() != 6) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not start with a prefix! " + aSTArray[0].getText() + "[" + N3Parser.getTokenNames()[aSTArray[0].getType()] + "]");
                return;
            }
            String string2 = aSTArray[0].getText();
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (aSTArray[1].getType() != 40) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not supply a URIref! " + aSTArray[1].getText());
                return;
            }
            String string3 = aSTArray[1].getText();
            if (string3.equals("")) {
                string3 = this.base;
            }
            if (string3.equals("#")) {
                string3 = this.base + "#";
            }
            if (VERBOSE) {
                System.out.println(string2 + " => " + string3);
            }
            this.setPrefixMapping(this.model, string2, string3);
            return;
        }
        this.warning("Line " + n + ": N3toRDF: Directive not recongized and ignored: " + aST.getText());
    }

    public void quad(int n, AST aST, AST aST2, AST aST3, String string) {
        if (string != null) {
            this.error("Line " + n + ": N3toRDF: All statement are asserted - no formulae");
        }
        try {
            Object object;
            Object object2;
            int n2 = aST2.getType();
            String string2 = aST2.getText();
            Property property = null;
            switch (n2) {
                case 28: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + n + ": N3toRDF: Propertry symbol '=>' not allowed");
                    }
                    string2 = LOG_IMPLIES;
                    break;
                }
                case 57: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + n + ": N3toRDF: Propertry symbol '<=>' not allowed");
                    }
                    string2 = LOG_MEANS;
                    break;
                }
                case 29: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + n + ": N3toRDF: Propertry symbol '<=' not allowed");
                    }
                    string2 = LOG_IMPLIES;
                    object2 = aST3;
                    aST3 = aST;
                    aST = object2;
                    break;
                }
                case 27: {
                    if (!this.allowPropertySymbols) {
                        this.error("Line " + n + ": N3toRDF: Propertry symbol '=' not allowed");
                    }
                    property = OWL.sameAs;
                    break;
                }
                case 13: {
                    if (!this.allowKeywordA) {
                        this.error("Line " + n + ": N3toRDF: Propertry symbol 'a' not allowed");
                    }
                    property = RDF.type;
                    break;
                }
                case 6: {
                    if (aST2.getText().startsWith("_:")) {
                        this.error("Line " + n + ": N3toRDF: Can't have properties with labelled bNodes in RDF");
                    }
                    if ((object = this.expandPrefix(this.model, string2)) == string2) {
                        this.error("Line " + n + ": N3toRDF: Undefined qname namespace: " + string2);
                        return;
                    }
                    property = this.model.createProperty((String)object);
                    break;
                }
                case 40: {
                    string2 = this.expandURIRef(string2);
                    break;
                }
                case 16: {
                    property = RDF.first;
                    break;
                }
                case 17: {
                    property = RDF.rest;
                    break;
                }
                case 4: {
                    this.error("Line " + n + ": N3toRDF: Can't have anon. properties in RDF");
                    break;
                }
                default: {
                    this.error("Line " + n + ": N3toRDF: Shouldn't see " + N3EventPrinter.formatSlot(aST2) + " at this point!");
                }
            }
            if (property == null) {
                property = this.model.createProperty(string2);
            } else {
                string2 = property.getURI();
            }
            object2 = this.createNode(n, aST);
            if (object2 instanceof Literal) {
                this.error("Line " + n + ": N3toRDF: Subject can't be a literal: " + aST.getText());
            }
            object = this.createNode(n, aST3);
            Statement statement = this.model.createStatement((Resource)object2, property, (RDFNode)object);
            if (VERBOSE) {
                System.out.println("Statement: " + statement);
            }
            this.model.add(statement);
        }
        catch (JenaException jenaException) {
            this.error("Line " + n + ": JenaException: " + jenaException);
        }
    }

    private RDFNode createNode(int n, AST aST) {
        String string = aST.getText();
        switch (aST.getType()) {
            case 38: {
                Resource resource = XSD.integer;
                if (string.indexOf(46) >= 0) {
                    resource = XSD.xdouble;
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                    resource = XSD.xdouble;
                }
                return this.model.createTypedLiteral(string, resource.getURI());
            }
            case 22: {
                String string2;
                AST aST2 = aST.getNextSibling();
                AST aST3 = aST2 == null ? null : aST2.getNextSibling();
                AST aST4 = null;
                AST aST5 = null;
                if (aST3 != null) {
                    if (aST3.getType() == 39) {
                        aST4 = aST3.getFirstChild();
                    } else {
                        aST5 = aST3;
                    }
                }
                if (aST2 != null) {
                    if (aST2.getType() == 39) {
                        aST4 = aST2.getFirstChild();
                    } else {
                        aST5 = aST2;
                    }
                }
                String string3 = string2 = aST5 != null ? aST5.getText().substring(1) : null;
                if (aST4 == null) {
                    return this.model.createLiteral(string, string2);
                }
                String string4 = aST4.getText();
                if (aST4.getType() != 6 && aST4.getType() != 40) {
                    this.error("Line " + n + ": N3toRDF: Must use URIref or QName datatype URI: " + string + "^^" + string4 + "(" + N3Parser.getTokenNames()[aST4.getType()] + ")");
                    return this.model.createLiteral("Illegal literal: " + string + "^^" + string4);
                }
                if (aST4.getType() == 6) {
                    if (string4.startsWith("_:") || string4.startsWith("=:")) {
                        this.error("Line " + n + ": N3toRDF: Can't use bNode for datatype URI: " + string + "^^" + string4);
                        return this.model.createLiteral("Illegal literal: " + string + "^^" + string4);
                    }
                    String string5 = this.expandPrefix(this.model, string4);
                    if (string5 == string4) {
                        this.error("Line " + n + ": N3toRDF: Undefined qname namespace in datatype: " + string4);
                    }
                    string4 = string5;
                }
                string4 = this.expandURIRef(string4);
                return this.model.createTypedLiteral(string, string4);
            }
            case 6: {
                if (string.startsWith("_:") && this.model.getNsPrefixURI("_") == null) {
                    if (!this.bNodeMap.containsKey(string)) {
                        this.bNodeMap.put(string, this.model.createResource());
                    }
                    return (Resource)this.bNodeMap.get(string);
                }
                String string6 = this.expandPrefix(this.model, string);
                if (string6 == string) {
                    this.error("Line " + n + ": N3toRDF: Undefined qname namespace: " + string);
                    return null;
                }
                return this.model.createResource(this.expandURIRef(string6));
            }
            case 40: {
                return this.model.createResource(this.expandURIRef(string));
            }
            case 18: {
                return RDF.nil;
            }
            case 15: {
                return RDF.List;
            }
            case 4: {
                if (!this.bNodeMap.containsKey(string)) {
                    this.bNodeMap.put(string, this.model.createResource());
                }
                return (Resource)this.bNodeMap.get(string);
            }
            case 41: {
                this.error("Line " + n + ": N3toRDF: Can't map variables to RDF: " + string);
                break;
            }
            default: {
                this.error("Line " + n + ": N3toRDF: Can't map to a resource or literal: " + AntlrUtils.ast(aST));
            }
        }
        return null;
    }

    private String expandURIRef(String string) {
        if (string.equals("")) {
            return this.base;
        }
        if (string.equals("#")) {
            return this.base + "#";
        }
        if (this.base != null && !this.hasURIscheme(string)) {
            if (!this.base.startsWith("file:")) {
                if (string.startsWith("#")) {
                    return this.base + string;
                }
                return this.base + "#" + string;
            }
            if (string.startsWith("#")) {
                return this.base + string;
            }
            if (string.startsWith("/")) {
                return "file:" + string;
            }
            return this.basedir + string;
        }
        return string;
    }

    private boolean hasURIscheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return true;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return false;
    }

    private void setPrefixMapping(Model model, String string, String string2) {
        try {
            this.model.setNsPrefix(string, string2);
        }
        catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
            this.warning("Prefix mapping '" + string + "' illegal: used but not recorded in model");
        }
        this.myPrefixMapping.put(string, string2);
    }

    private String expandPrefix(Model model, String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = (String)this.myPrefixMapping.get(string2);
        if (string3 == null) {
            return string;
        }
        return string3 + string.substring(n + 1);
    }
}

