/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.GraphMemBulkUpdateHandler;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MixedGraphMem
extends GraphMemBase
implements Graph {
    protected Thing thing = new Thing(this);

    public MixedGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public MixedGraphMem(ReificationStyle reificationStyle) {
        super(reificationStyle);
    }

    public void performAdd(Triple triple) {
        if (!this.getReifier().handledAdd(triple)) {
            this.thing.add(triple);
        }
    }

    public void performDelete(Triple triple) {
        if (!this.getReifier().handledRemove(triple)) {
            this.thing.remove(triple);
        }
    }

    public int graphBaseSize() {
        return this.thing.size();
    }

    public boolean graphBaseContains(Triple triple) {
        return triple.isConcrete() ? this.thing.contains(triple) : this.containsByFind(triple);
    }

    protected void destroy() {
        this.thing = null;
    }

    public boolean isEmpty() {
        this.checkOpen();
        return this.thing.isEmpty();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new GraphMemBulkUpdateHandler(this){

                protected void clearComponents() {
                    MixedGraphMem mixedGraphMem = (MixedGraphMem)this.graph;
                    mixedGraphMem.thing.clear();
                }
            };
        }
        return this.bulkHandler;
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        Triple triple = tripleMatch.asTriple();
        Node node = triple.getSubject();
        Node node2 = triple.getPredicate();
        Node node3 = triple.getObject();
        return node.isConcrete() ? this.thing.iterator(node, triple) : (node2.isConcrete() ? this.thing.iterator(node2, triple) : (node3.isURI() || node3.isBlank() ? this.thing.iterator(node3, triple) : this.thing.iterator(tripleMatch.asTriple())));
    }

    public static class Thing {
        protected final Graph parent;
        protected Map map = CollectionFactory.createHashedMap();
        protected int size = 0;

        public Thing(Graph graph) {
            this.parent = graph;
        }

        protected boolean add(Node node, Triple triple) {
            Set set = (Set)this.map.get(node);
            if (set == null) {
                set = CollectionFactory.createHashedSet();
                this.map.put(node, set);
            }
            return set.add(triple);
        }

        protected boolean remove(Node node, Triple triple) {
            Set set = (Set)this.map.get(node);
            if (set != null) {
                boolean bl = set.remove(triple);
                if (set.isEmpty()) {
                    this.map.put(node, null);
                }
                return bl;
            }
            return false;
        }

        public void add(Triple triple) {
            if (this.add(triple.getSubject(), triple)) {
                ++this.size;
            }
            this.add(triple.getPredicate(), triple);
            this.add(triple.getObject(), triple);
        }

        public void remove(Triple triple) {
            if (this.remove(triple.getSubject(), triple)) {
                --this.size;
            }
            this.remove(triple.getPredicate(), triple);
            this.remove(triple.getObject(), triple);
        }

        public boolean contains(Triple triple) {
            Set set = (Set)this.map.get(triple.getSubject());
            return set != null && set.contains(triple);
        }

        public ExtendedIterator iterator(final Node node, Triple triple) {
            Set set = (Set)this.map.get(node);
            if (set == null) {
                return NullIterator.instance;
            }
            final Iterator iterator = set.iterator();
            return new NiceIterator(){
                private Triple remember = null;

                public Object next() {
                    this.remember = (Triple)iterator.next();
                    return this.remember;
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public void excise(Node node2, Triple triple) {
                    if (node2 != node) {
                        Thing.this.remove(node2, triple);
                    }
                }

                public void remove() {
                    iterator.remove();
                    --Thing.this.size;
                    this.excise(this.remember.getSubject(), this.remember);
                    this.excise(this.remember.getPredicate(), this.remember);
                    this.excise(this.remember.getObject(), this.remember);
                    Thing.this.parent.getEventManager().notifyDeleteTriple(Thing.this.parent, this.remember);
                }
            }.filterKeep(new TripleMatchFilter(triple));
        }

        public ExtendedIterator iterator(final Triple triple) {
            return new NiceIterator(){
                protected Iterator keys;
                protected Iterator current;
                protected Triple triple;
                protected Triple remember;
                protected Node key;
                protected Set seen;
                protected Filter filter;
                protected Triple ANY;
                {
                    this.keys = Thing.this.map.keySet().iterator();
                    this.current = NullIterator.instance;
                    this.triple = null;
                    this.remember = null;
                    this.key = null;
                    this.seen = CollectionFactory.createHashedSet();
                    this.filter = new TripleMatchFilter(triple);
                    this.ANY = Triple.create("?? ?? ??");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object next() {
                    this.ensureHasNext();
                    try {
                        Triple triple2 = this.remember = this.triple;
                        return triple2;
                    }
                    finally {
                        this.triple = null;
                    }
                }

                public boolean hasNext() {
                    if (this.triple == null) {
                        while (this.current.hasNext()) {
                            this.triple = (Triple)this.current.next();
                            if (!triple.matches(this.triple) || this.seen.contains(this.triple)) {
                                this.triple = null;
                                continue;
                            }
                            this.seen.add(this.triple);
                            return true;
                        }
                        if (this.keys.hasNext()) {
                            this.key = (Node)this.keys.next();
                            Set set = (Set)Thing.this.map.get(this.key);
                            if (set == null) {
                                return this.hasNext();
                            }
                            this.current = set.iterator();
                            return this.hasNext();
                        }
                        return false;
                    }
                    return true;
                }

                public void excise(Node node, Triple triple2) {
                    if (node != this.key) {
                        Thing.this.remove(node, triple2);
                    }
                }

                public void remove() {
                    this.current.remove();
                    --Thing.this.size;
                    this.excise(this.remember.getSubject(), this.remember);
                    this.excise(this.remember.getPredicate(), this.remember);
                    this.excise(this.remember.getObject(), this.remember);
                    Thing.this.parent.getEventManager().notifyDeleteTriple(Thing.this.parent, this.remember);
                }
            };
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.map.clear();
            this.size = 0;
        }
    }
}

