/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.test.JenaTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GraphTestBase
extends JenaTestBase {
    static int bnc = 1000;

    public GraphTestBase(String string) {
        super(string);
    }

    public static Node node(String string) {
        return Node.create(string);
    }

    public static Model modelFor(Graph graph) {
        return ModelFactory.createModelForGraph(graph);
    }

    public static Set iteratorToSet(Iterator iterator) {
        return IteratorCollection.iteratorToSet(iterator);
    }

    public static List iteratorToList(Iterator iterator) {
        return IteratorCollection.iteratorToList(iterator);
    }

    public Set nodeSet(String string) {
        Set set = CollectionFactory.createHashedSet();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return set;
    }

    public Set arrayToSet(Object[] objectArray) {
        return CollectionFactory.createHashedSet(Arrays.asList(objectArray));
    }

    public static Triple triple(String string) {
        return Triple.create(string);
    }

    public static Triple triple(PrefixMapping prefixMapping, String string) {
        return Triple.create(prefixMapping, string);
    }

    public static Triple[] tripleArray(String string) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(GraphTestBase.triple(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Triple[arrayList.size()]);
    }

    public static Set tripleSet(String string) {
        HashSet<Triple> hashSet = new HashSet<Triple>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(GraphTestBase.triple(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public static Node[] nodes(String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static Graph graphAdd(Graph graph, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            graph.add(GraphTestBase.triple(PrefixMapping.Extended, stringTokenizer.nextToken()));
        }
        return graph;
    }

    public static Graph newGraph() {
        GraphMem graphMem = new GraphMem();
        graphMem.getPrefixMapping().setNsPrefixes(PrefixMapping.Extended);
        return graphMem;
    }

    public static Graph graphWith(String string) {
        return GraphTestBase.graphAdd(GraphTestBase.newGraph(), string);
    }

    public static void assertEqualsTemplate(String string, Graph graph, String string2) {
        GraphTestBase.assertIsomorphic(string, GraphTestBase.graphWith(string2), graph);
    }

    public static void assertIsomorphic(String string, Graph graph, Graph graph2) {
        if (!graph.isIsomorphicWith(graph2)) {
            Map map = CollectionFactory.createHashedMap();
            GraphTestBase.fail((String)(string + ": wanted " + GraphTestBase.nice(graph, map) + "\nbut got " + GraphTestBase.nice(graph2, map)));
        }
    }

    protected static String nice(Graph graph, Map map) {
        StringBuffer stringBuffer = new StringBuffer(graph.size() * 100);
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            GraphTestBase.niceTriple(stringBuffer, map, (Triple)extendedIterator.next());
        }
        return stringBuffer.toString();
    }

    protected static void niceTriple(StringBuffer stringBuffer, Map map, Triple triple) {
        stringBuffer.append("\n    ");
        GraphTestBase.appendNode(stringBuffer, map, triple.getSubject());
        GraphTestBase.appendNode(stringBuffer, map, triple.getPredicate());
        GraphTestBase.appendNode(stringBuffer, map, triple.getObject());
    }

    protected static void appendNode(StringBuffer stringBuffer, Map map, Node node) {
        stringBuffer.append(' ');
        if (node.isBlank()) {
            Object object = map.get(node);
            if (object == null) {
                object = "_b" + bnc++;
                map.put(node, object);
            }
            stringBuffer.append(object);
        } else {
            stringBuffer.append(node.toString(PrefixMapping.Extended, true));
        }
    }

    public static void assertIsomorphic(Graph graph, Graph graph2) {
        GraphTestBase.assertIsomorphic("graphs must be isomorphic", graph, graph2);
    }

    public static void assertContains(String string, String string2, Graph graph) {
        GraphTestBase.assertTrue((String)(string + " must contain " + string2), (boolean)graph.contains(GraphTestBase.triple(string2)));
    }

    public static void assertContainsAll(String string, Graph graph, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            GraphTestBase.assertContains(string, stringTokenizer.nextToken(), graph);
        }
    }

    public void assertOmits(String string, Graph graph, String string2) {
        GraphTestBase.assertFalse((String)(string + " must not contain " + string2), (boolean)graph.contains(GraphTestBase.triple(string2)));
    }

    public void assertOmitsAll(String string, Graph graph, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.assertOmits(string, graph, stringTokenizer.nextToken());
        }
    }

    public static boolean contains(Graph graph, String string) {
        return graph.contains(GraphTestBase.triple(string));
    }

    public void testContains(Graph graph, Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            GraphTestBase.assertTrue((String)("contains " + tripleArray[i]), (boolean)graph.contains(tripleArray[i]));
        }
    }

    public void testContains(Graph graph, List list) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTestBase.assertTrue((boolean)graph.contains((Triple)list.get(i)));
        }
    }

    public void testContains(Graph graph, Iterator iterator) {
        while (iterator.hasNext()) {
            GraphTestBase.assertTrue((boolean)graph.contains((Triple)iterator.next()));
        }
    }

    public void testContains(Graph graph, Graph graph2) {
        this.testContains(graph, GraphUtil.findAll(graph2));
    }

    public void testOmits(Graph graph, Triple[] tripleArray) {
        for (int i = 0; i < tripleArray.length; ++i) {
            GraphTestBase.assertFalse((String)"", (boolean)graph.contains(tripleArray[i]));
        }
    }

    public void testOmits(Graph graph, List list) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTestBase.assertFalse((String)"", (boolean)graph.contains((Triple)list.get(i)));
        }
    }

    public void testOmits(Graph graph, Iterator iterator) {
        while (iterator.hasNext()) {
            GraphTestBase.assertFalse((String)"", (boolean)graph.contains((Triple)iterator.next()));
        }
    }

    public void testOmits(Graph graph, Graph graph2) {
        this.testOmits(graph, GraphUtil.findAll(graph2));
    }

    public static void show(String string, Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        System.out.println(string);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            System.out.println("  " + triple.getSubject() + " @" + triple.getPredicate() + " " + triple.getObject());
        }
    }

    public static Graph getGraph(Object object, Class clazz, ReificationStyle reificationStyle) {
        try {
            Constructor constructor = GraphTestBase.getConstructor(clazz, new Class[]{ReificationStyle.class});
            if (constructor != null) {
                return (Graph)constructor.newInstance(reificationStyle);
            }
            Constructor constructor2 = GraphTestBase.getConstructor(clazz, new Class[]{object.getClass(), ReificationStyle.class});
            if (constructor2 != null) {
                return (Graph)constructor2.newInstance(object, reificationStyle);
            }
            throw new JenaException("no suitable graph constructor found for " + clazz);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    protected static Graph getReificationTriples(final Reifier reifier) {
        return new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                return reifier.find(tripleMatch);
            }
        };
    }
}

