/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphMatcher;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public abstract class GraphBase
implements GraphWithPerform {
    protected final ReificationStyle style;
    protected boolean closed = false;
    protected QueryHandler queryHandler;
    protected GraphEventManager gem;
    protected BulkUpdateHandler bulkHandler;
    protected Capabilities capabilities = null;
    protected PrefixMapping pm = new PrefixMappingImpl();
    protected Reifier reifier = null;

    public GraphBase() {
        this(ReificationStyle.Minimal);
    }

    public GraphBase(ReificationStyle reificationStyle) {
        this.style = reificationStyle;
    }

    protected void checkOpen() {
        if (this.closed) {
            throw new ClosedException("already closed", this);
        }
    }

    public void close() {
        this.closed = true;
        if (this.reifier != null) {
            this.reifier.close();
        }
    }

    public boolean dependsOn(Graph graph) {
        return this == graph;
    }

    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new SimpleQueryHandler(this);
        }
        return this.queryHandler;
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new SimpleEventManager(this);
        }
        return this.gem;
    }

    public void notifyAdd(Triple triple) {
        this.getEventManager().notifyAddTriple(this, triple);
    }

    public void notifyDelete(Triple triple) {
        this.getEventManager().notifyDeleteTriple(this, triple);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new SimpleBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        return this.pm;
    }

    public void add(Triple triple) {
        this.checkOpen();
        this.performAdd(triple);
        this.notifyAdd(triple);
    }

    public void performAdd(Triple triple) {
        throw new AddDeniedException("GraphBase::performAdd");
    }

    public final void delete(Triple triple) {
        this.checkOpen();
        this.performDelete(triple);
        this.notifyDelete(triple);
    }

    public void performDelete(Triple triple) {
        throw new DeleteDeniedException("GraphBase::delete");
    }

    public final ExtendedIterator find(TripleMatch tripleMatch) {
        this.checkOpen();
        return this.reifierTriples(tripleMatch).andThen(this.graphBaseFind(tripleMatch));
    }

    protected abstract ExtendedIterator graphBaseFind(TripleMatch var1);

    public final ExtendedIterator find(Node node, Node node2, Node node3) {
        this.checkOpen();
        return this.graphBaseFind(node, node2, node3);
    }

    protected ExtendedIterator graphBaseFind(Node node, Node node2, Node node3) {
        return this.find(Triple.createMatch(node, node2, node3));
    }

    public final boolean contains(Triple triple) {
        this.checkOpen();
        return this.reifierContains(triple) || this.graphBaseContains(triple);
    }

    protected boolean reifierContains(Triple triple) {
        return this.getReifier().findExposed(triple).hasNext();
    }

    protected boolean graphBaseContains(Triple triple) {
        return this.containsByFind(triple);
    }

    public final boolean contains(Node node, Node node2, Node node3) {
        this.checkOpen();
        return this.contains(Triple.create(node, node2, node3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean containsByFind(Triple triple) {
        ExtendedIterator extendedIterator = this.find(triple);
        try {
            boolean bl = extendedIterator.hasNext();
            return bl;
        }
        finally {
            extendedIterator.close();
        }
    }

    protected ExtendedIterator reifierTriples(TripleMatch tripleMatch) {
        return this.getReifier().findExposed(tripleMatch);
    }

    public Reifier getReifier() {
        if (this.reifier == null) {
            this.reifier = new SimpleReifier(this, this.style);
        }
        return this.reifier;
    }

    public final int size() {
        this.checkOpen();
        return this.graphBaseSize() + this.reifierSize();
    }

    protected int reifierSize() {
        return this.getReifier().size();
    }

    protected int graphBaseSize() {
        ExtendedIterator extendedIterator = GraphUtil.findAll(this);
        int n = 0;
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isIsomorphicWith(Graph graph) {
        this.checkOpen();
        return graph != null && GraphMatcher.equals(this, graph);
    }

    public String toString() {
        return GraphBase.toString(this.closed ? "closed " : "", this);
    }

    public static String toString(String string, Graph graph) {
        PrefixMapping prefixMapping = graph.getPrefixMapping();
        StringBuffer stringBuffer = new StringBuffer(string + " {");
        String string2 = "";
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        while (extendedIterator.hasNext()) {
            stringBuffer.append(string2);
            string2 = "; ";
            stringBuffer.append(((Triple)extendedIterator.next()).toString(prefixMapping));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

