/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Driver_MySQL
extends DriverRDB {
    public Driver_MySQL() {
        String string = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "MySQL";
        this.DRIVER_NAME = "com.mysql.jdbc.Driver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 250;
        this.INDEX_KEY_LENGTH_MAX = 250;
        this.LONG_OBJECT_LENGTH = 250;
        this.LONG_OBJECT_LENGTH_MAX = 250;
        this.TABLE_NAME_LENGTH_MAX = 64;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = false;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/mysql.sql";
        this.DB_NAMES_TO_UPPER = false;
        this.setTableNames(this.TABLE_NAME_PREFIX);
        this.m_psetClassName = string + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = string + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = string + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = string + ".SpecializedGraphReifier_RDB";
    }

    public void setConnection(IDBConnection iDBConnection) {
        this.m_dbcon = iDBConnection;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, null, iDBConnection, this.ID_SQL_TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            logger.error((Object)"Unable to set connection for Driver:", (Throwable)exception);
        }
    }

    public int graphIdAlloc(String string) {
        Object var2_2 = null;
        int n = 0;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("insertGraph", this.GRAPH_TABLE);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            n = this.getInsertID(this.GRAPH_TABLE);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to get last inserted ID: " + sQLException);
        }
        return n;
    }

    public void graphIdDealloc(int n) {
        Object var2_2 = null;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("deleteGraph", this.GRAPH_TABLE);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to delete graph ID: " + sQLException);
        }
    }

    public int getInsertID(String string) {
        DBIDInt dBIDInt = null;
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("getInsertID");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new RDFRDBException("No last insert ID");
            }
            dBIDInt = this.wrapDBID(resultSet.getObject(1));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to get last inserted ID: " + sQLException);
        }
        return dBIDInt.getIntID();
    }

    protected void getTblParams(String[] stringArray) {
        String string;
        String string2;
        String string3;
        String string4 = Integer.toString(this.LONG_OBJECT_LENGTH);
        String string5 = Integer.toString(this.INDEX_KEY_LENGTH);
        if (this.INDEX_KEY_LENGTH > 250) {
            throw new RDFRDBException("Key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds MySQL maximum key length of 250.");
        }
        String string6 = string3 = this.IS_XACT_DB ? "INNODB" : "MyISAM";
        if (this.IS_XACT_DB) {
            if (this.LONG_OBJECT_LENGTH > 250) {
                throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds MySQL maximum VARCHAR length of 250.");
            }
            string2 = "VARCHAR(" + this.LONG_OBJECT_LENGTH + ") BINARY";
            this.STRINGS_TRIMMED = true;
            this.EOS = ":";
        } else {
            string2 = this.LONG_OBJECT_LENGTH <= 250 ? "TINYBLOB" : "MEDIUMBLOB";
            this.STRINGS_TRIMMED = false;
            this.EOS = "";
        }
        if (this.IS_XACT_DB) {
            if (this.INDEX_KEY_LENGTH > 250) {
                throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds MySQL maximum VARCHAR length of 250.");
            }
            string = "VARCHAR(" + this.INDEX_KEY_LENGTH + ") BINARY";
        } else {
            string = this.INDEX_KEY_LENGTH <= 250 ? "TINYBLOB" : "MEDIUMBLOB";
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        stringArray[2] = string4;
        stringArray[3] = string;
        stringArray[4] = string5;
        stringArray[5] = this.TABLE_NAME_PREFIX;
    }

    protected String[] getDbInitTablesParams() {
        String[] stringArray = new String[6];
        this.getTblParams(stringArray);
        if (this.IS_XACT_DB) {
            this.STRINGS_TRIMMED = true;
            this.EOS = ":";
        } else {
            this.STRINGS_TRIMMED = false;
            this.EOS = "";
        }
        this.EOS_LEN = this.EOS.length();
        return stringArray;
    }

    protected String[] getCreateTableParams(int n, boolean bl) {
        String[] stringArray = new String[6];
        String[] stringArray2 = new String[4];
        this.getTblParams(stringArray);
        int n2 = this.getTableCount(n);
        stringArray2[0] = this.genTableName(n, n2, bl);
        stringArray2[1] = stringArray[0];
        stringArray2[2] = stringArray[1];
        stringArray2[3] = stringArray[2];
        return stringArray2;
    }

    public String genSQLStringMatchLHS_IC(String string) {
        return "cast(" + string + " as char)";
    }
}

