/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.DBPattern;
import com.hp.hpl.jena.db.impl.DBQueryStage;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.shared.JenaException;
import java.util.ArrayList;
import java.util.Iterator;

public class DBQueryHandler
extends SimpleQueryHandler {
    private GraphRDB graph;
    boolean queryOnlyStmt;
    boolean queryOnlyReif;
    boolean queryFullReif;
    private boolean doFastpath;

    public DBQueryHandler(GraphRDB graphRDB) {
        super(graphRDB);
        this.graph = graphRDB;
        if (graphRDB.reificationBehavior() == 1) {
            this.queryOnlyStmt = false;
            this.queryOnlyReif = false;
            this.queryFullReif = false;
        } else {
            this.queryOnlyReif = false;
            this.queryFullReif = false;
            this.queryOnlyStmt = true;
        }
        this.doFastpath = true;
    }

    public void setDoFastpath(boolean bl) {
        this.doFastpath = bl;
    }

    public boolean getDoFastpath() {
        return this.doFastpath;
    }

    public Stage patternStage(Mapping mapping, ExpressionSet expressionSet, Triple[] tripleArray) {
        int n;
        final Stage[] stageArray = new Stage[tripleArray.length];
        int n2 = 0;
        DBPattern[] dBPatternArray = new DBPattern[tripleArray.length];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < tripleArray.length; ++n) {
            arrayList.add(new Integer(n));
        }
        int n4 = this.graph.reificationBehavior();
        if (arrayList.size() == 1 && !expressionSet.isComplex() || !this.doFastpath) {
            for (n = 0; n < arrayList.size(); ++n) {
                stageArray[n2++] = super.patternStage(mapping, expressionSet, new Triple[]{tripleArray[n]});
            }
        } else {
            int n5;
            DBPattern dBPattern;
            for (n = 0; n < tripleArray.length; ++n) {
                Triple triple = tripleArray[n];
                dBPattern = new DBPattern(triple, mapping);
                Iterator iterator = this.graph.getSpecializedGraphs();
                while (iterator.hasNext()) {
                    SpecializedGraph specializedGraph = (SpecializedGraph)iterator.next();
                    n5 = specializedGraph.subsumes(triple, n4);
                    if (n5 == 110) continue;
                    dBPattern.sourceAdd(specializedGraph, (char)n5);
                    if (n5 != 97) continue;
                    break;
                }
                dBPatternArray[n] = dBPattern;
            }
            DBPattern dBPattern2 = null;
            boolean bl = false;
            while (arrayList.size() > 0) {
                int n6 = 100;
                int n7 = 100;
                bl = false;
                DBPattern dBPattern3 = null;
                int n8 = -1;
                for (n = 0; n < arrayList.size(); ++n) {
                    dBPattern2 = dBPatternArray[(Integer)arrayList.get(n)];
                    n5 = dBPattern2.cost(mapping);
                    if (dBPattern2.isConnected) {
                        if (n5 >= n6) continue;
                        dBPattern3 = dBPattern2;
                        n6 = n5;
                        bl = true;
                        n8 = n;
                        continue;
                    }
                    if (n5 >= n7 || bl) continue;
                    n7 = n5;
                    dBPattern3 = dBPattern2;
                    n8 = n;
                }
                if (dBPattern3 == null) {
                    dBPattern = dBPattern2;
                    n8 = n - 1;
                } else {
                    dBPattern = dBPattern3;
                }
                dBPattern.isStaged = true;
                arrayList.remove(n8);
                ArrayList arrayList2 = new ArrayList();
                ExpressionSet expressionSet2 = new ExpressionSet();
                ArrayList<DBPattern> arrayList3 = new ArrayList<DBPattern>();
                arrayList3.add(dBPattern);
                boolean bl2 = false;
                boolean bl3 = false;
                if (dBPattern.isSingleSource()) {
                    VarDesc varDesc;
                    boolean bl4;
                    dBPattern.addFreeVars(arrayList2);
                    do {
                        bl4 = false;
                        for (n = 0; n < arrayList.size(); ++n) {
                            dBPattern2 = dBPatternArray[(Integer)arrayList.get(n)];
                            if (!dBPattern2.joinsWith(dBPattern, arrayList2, this.queryOnlyStmt, this.queryOnlyReif)) continue;
                            arrayList3.add(dBPattern2);
                            arrayList.remove(n);
                            dBPattern2.addFreeVars(arrayList2);
                            dBPattern2.isStaged = true;
                            bl3 = true;
                            bl4 = true;
                        }
                    } while (bl4 && arrayList.size() > 0);
                    if (bl3) {
                        bl2 = true;
                    } else {
                        for (n = 0; n < arrayList2.size(); ++n) {
                            varDesc = (VarDesc)arrayList2.get(n);
                            if (varDesc.isArgVar || !this.findConstraints(expressionSet, expressionSet2, varDesc)) continue;
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        for (n = 0; n < arrayList2.size(); ++n) {
                            varDesc = (VarDesc)arrayList2.get(n);
                            if (varDesc.isArgVar) continue;
                            varDesc.bindToVarMap(mapping);
                        }
                    }
                } else if (!dBPattern.hasSource()) {
                    bl2 = true;
                }
                stageArray[n2] = bl2 ? new DBQueryStage(this.graph, dBPattern.hasSource() ? dBPattern.singleSource() : null, arrayList2, arrayList3, expressionSet2) : super.patternStage(mapping, expressionSet, new Triple[]{dBPattern.pattern});
                ++n2;
            }
        }
        final Integer n9 = new Integer(n2);
        return new Stage(){

            public Stage connectFrom(Stage stage) {
                for (int i = 0; i < n9; ++i) {
                    stageArray[i].connectFrom(stage);
                    stage = stageArray[i];
                }
                return super.connectFrom(stage);
            }

            public Pipe deliver(Pipe pipe) {
                return stageArray[n9 - 1].deliver(pipe);
            }
        };
    }

    public void setQueryOnlyAsserted(boolean bl) {
        if (bl && this.queryOnlyReif) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyStmt = bl;
    }

    public boolean getQueryOnlyAsserted() {
        return this.queryOnlyStmt;
    }

    public void setQueryOnlyReified(boolean bl) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        if (bl && this.queryOnlyReif) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyReif = true;
        throw new JenaException("QueryOnlyReified is not yet supported");
    }

    public boolean getQueryOnlyReified() {
        return this.queryOnlyReif;
    }

    public void setQueryFullReified(boolean bl) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        this.queryFullReif = true;
    }

    public boolean getQueryFullReified() {
        return this.queryFullReif;
    }

    private boolean findConstraints(ExpressionSet expressionSet, ExpressionSet expressionSet2, VarDesc varDesc) {
        boolean bl = false;
        Iterator iterator = expressionSet.iterator();
        while (iterator.hasNext()) {
            String string;
            Expression expression;
            Expression expression2 = (Expression)iterator.next();
            if (!expression2.isApply() || expression2.argCount() != 2 || !(expression = expression2.getArg(0)).isVariable() || !varDesc.var.getName().equals(expression.getName()) || !(string = expression2.getFun()).equals("urn:x-jena:expr:J_startsWith") && !string.equals("urn:x-jena:expr:J_startsWithInsensitive") && !string.equals("urn:x-jena:expr:J_contains") && !string.equals("urn:x-jena:expr:J_containsInsensitive") && !string.equals("urn:x-jena:expr:J_endsWith") && !string.equals("urn:x-jena:expr:J_endsWithInsensitive")) continue;
            expressionSet2.add(expression2);
            bl = true;
        }
        return bl;
    }
}

