/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.DBPropPrefix;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.DB;

public class DBPropGraph
extends DBProp {
    public static Node_URI graphName = (Node_URI)DB.graphName.getNode();
    public static Node_URI graphType = (Node_URI)DB.graphType.getNode();
    public static Node_URI graphLSet = (Node_URI)DB.graphLSet.getNode();
    public static Node_URI graphPrefix = (Node_URI)DB.graphPrefix.getNode();
    public static Node_URI graphId = (Node_URI)DB.graphId.getNode();
    public static Node_URI stmtTable = (Node_URI)DB.stmtTable.getNode();
    public static Node_URI reifTable = (Node_URI)DB.reifTable.getNode();

    public DBPropGraph(SpecializedGraph specializedGraph, String string, String string2) {
        super(specializedGraph);
        this.putPropString(graphName, string);
        this.putPropString(graphType, string2);
    }

    public DBPropGraph(SpecializedGraph specializedGraph, Node node) {
        super(specializedGraph, node);
    }

    public DBPropGraph(SpecializedGraph specializedGraph, String string, Graph graph) {
        super(specializedGraph);
        this.putPropString(graphName, string);
        ExtendedIterator extendedIterator = graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            if (triple.getPredicate().equals(graphName) || triple.getPredicate().equals(graphId) || triple.getPredicate().equals(stmtTable) || triple.getPredicate().equals(reifTable)) continue;
            this.putPropNode((Node_URI)triple.getPredicate(), triple.getObject());
        }
    }

    public void addLSet(DBPropLSet dBPropLSet) {
        this.putPropNode(graphLSet, dBPropLSet.getNode());
    }

    public void addPrefix(DBPropPrefix dBPropPrefix) {
        DBPropPrefix dBPropPrefix2 = this.getPrefix(dBPropPrefix.getValue());
        if (dBPropPrefix2 != null) {
            this.removePrefix(dBPropPrefix2);
        }
        if ((dBPropPrefix2 = this.getURI(dBPropPrefix.getURI())) != null && !dBPropPrefix.getValue().equals("")) {
            this.removePrefix(dBPropPrefix2);
        }
        this.putPropNode(graphPrefix, dBPropPrefix.getNode());
    }

    public void removePrefix(DBPropPrefix dBPropPrefix) {
        SpecializedGraph.CompletionFlag completionFlag = DBPropGraph.newComplete();
        ExtendedIterator extendedIterator = this.graph.find(this.self, graphPrefix, dBPropPrefix.getNode(), completionFlag);
        if (extendedIterator.hasNext()) {
            this.graph.delete((Triple)extendedIterator.next(), completionFlag);
            dBPropPrefix.remove();
        }
    }

    public void addPrefix(String string, String string2) {
        this.addPrefix(new DBPropPrefix(this.graph, string, string2));
    }

    public void removePrefix(String string) {
        DBPropPrefix dBPropPrefix = this.getPrefix(string);
        if (dBPropPrefix != null) {
            this.removePrefix(dBPropPrefix);
        }
    }

    public void addGraphId(int n) {
        this.putPropString(graphId, Integer.toString(n));
    }

    public void addStmtTable(String string) {
        this.putPropString(stmtTable, string);
    }

    public void addReifTable(String string) {
        this.putPropString(reifTable, string);
    }

    public String getName() {
        return this.getPropString(graphName);
    }

    public String getType() {
        return this.getPropString(graphType);
    }

    public String getStmtTable() {
        return this.getPropString(stmtTable);
    }

    public String getReifTable() {
        return this.getPropString(reifTable);
    }

    public int getGraphId() {
        String string = this.getPropString(graphId);
        return string == null ? -1 : Integer.parseInt(string);
    }

    public ExtendedIterator getAllLSets() {
        return this.graph.find(this.self, graphLSet, null, DBPropGraph.newComplete()).mapWith(new MapToLSet());
    }

    public ExtendedIterator getAllPrefixes() {
        return this.graph.find(this.self, graphPrefix, null, DBPropGraph.newComplete()).mapWith(new MapToPrefix());
    }

    public DBPropPrefix getPrefix(String string) {
        ExtendedIterator extendedIterator = this.getAllPrefixes();
        while (extendedIterator.hasNext()) {
            DBPropPrefix dBPropPrefix = (DBPropPrefix)extendedIterator.next();
            if (dBPropPrefix.getValue().compareTo(string) != 0) continue;
            return dBPropPrefix;
        }
        return null;
    }

    public DBPropPrefix getURI(String string) {
        ExtendedIterator extendedIterator = this.getAllPrefixes();
        while (extendedIterator.hasNext()) {
            DBPropPrefix dBPropPrefix = (DBPropPrefix)extendedIterator.next();
            if (dBPropPrefix.getURI().compareTo(string) != 0) continue;
            return dBPropPrefix;
        }
        return null;
    }

    public ExtendedIterator listTriples() {
        ExtendedIterator extendedIterator = DBProp.listTriples(this.graph, this.self);
        ExtendedIterator extendedIterator2 = this.getAllLSets();
        while (extendedIterator2.hasNext()) {
            extendedIterator = extendedIterator.andThen(((DBPropLSet)extendedIterator2.next()).listTriples());
        }
        ExtendedIterator extendedIterator3 = this.getAllPrefixes();
        while (extendedIterator3.hasNext()) {
            extendedIterator = extendedIterator.andThen(((DBPropPrefix)extendedIterator3.next()).listTriples());
        }
        return extendedIterator;
    }

    public static DBPropGraph findPropGraphByName(SpecializedGraph specializedGraph, String string) {
        Node node = Node.createLiteral(string);
        ExtendedIterator extendedIterator = specializedGraph.find(null, graphName, node, DBPropGraph.newComplete());
        if (extendedIterator.hasNext()) {
            return new DBPropGraph(specializedGraph, ((Triple)extendedIterator.next()).getSubject());
        }
        return null;
    }

    public boolean isDBPropGraphOk(String string) {
        String string2 = this.getName();
        boolean bl = string2 == null ? false : string2.equals(string);
        bl &= this.getGraphId() != -1;
        bl &= this.getType() != null;
        bl &= this.getStmtTable() != null;
        return bl &= this.getReifTable() != null;
    }

    public void remove() {
        ExtendedIterator extendedIterator = this.getAllPrefixes();
        while (extendedIterator.hasNext()) {
            ((DBPropPrefix)extendedIterator.next()).remove();
        }
        extendedIterator = this.getAllLSets();
        while (extendedIterator.hasNext()) {
            ((DBPropLSet)extendedIterator.next()).remove();
        }
        super.remove();
    }

    private class MapToPrefix
    implements Map1 {
        private MapToPrefix() {
        }

        public Object map1(Object object) {
            Triple triple = (Triple)object;
            return new DBPropPrefix(DBPropGraph.this.graph, triple.getObject());
        }
    }

    private class MapToLSet
    implements Map1 {
        private MapToLSet() {
        }

        public Object map1(Object object) {
            Triple triple = (Triple)object;
            return new DBPropLSet(DBPropGraph.this.graph, triple.getObject());
        }
    }
}

