/*
 * Decompiled with CFR 0.152.
 */
package com.ldodds.sparql;

import com.ldodds.sparql.MenuFactory;
import com.ldodds.sparql.RunQueryCommand;
import com.ldodds.sparql.Twinkle;
import com.ldodds.util.FileFilters;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.undo.UndoManager;

public class TwinkleFrame
extends JFrame {
    private JTextArea _query;
    private JTextArea _results;
    private JTextField _dataUrl;
    private JTextField _baseUrl;
    private UndoManager _undoManager;
    private JLabel _statusBar;
    private JPanel _resultsPanel;
    private JTable _resultsTable;

    public TwinkleFrame(String title) {
        super(title);
        Twinkle.ui = this;
        this._query = new JTextArea();
        this._results = new JTextArea();
        this._dataUrl = new JTextField(24);
        this._dataUrl.setToolTipText("Local Data File or URL");
        this._baseUrl = new JTextField(24);
        this._baseUrl.setToolTipText("Base URL for resolving relative URLs");
        this._statusBar = new JLabel("");
        this._undoManager = new UndoManager();
        this._resultsTable = new JTable();
        this.setDefaultWindowSize();
        this.addWindowListener();
        this.createMenu();
        this.createPanels();
    }

    private void addWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void setDefaultWindowSize() {
        int inset = 75;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
    }

    private void createPanels() {
        JSplitPane splitter = new JSplitPane(0, this.createQueryPanel(), this.createResultsPanel());
        this.getContentPane().add(splitter);
    }

    private JPanel createQueryPanel() {
        JPanel queryPanel = new JPanel();
        queryPanel.setLayout(new BorderLayout());
        this._query.getDocument().addUndoableEditListener(this._undoManager);
        JScrollPane scrollPane = new JScrollPane(this._query);
        queryPanel.add((Component)scrollPane, "Center");
        queryPanel.add((Component)this.createOptionsPanel(), "East");
        return queryPanel;
    }

    private JPanel createOptionsPanel() {
        JPanel options = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        options.setLayout(layout);
        JLabel baseUrlLabel = new JLabel("Base URI");
        baseUrlLabel.setLabelFor(this._baseUrl);
        GridBagConstraints baseLabelConstraints = new GridBagConstraints();
        baseLabelConstraints.gridx = 0;
        baseLabelConstraints.gridy = 0;
        baseLabelConstraints.gridwidth = 3;
        baseLabelConstraints.gridheight = 1;
        baseLabelConstraints.anchor = 18;
        baseLabelConstraints.insets = new Insets(0, 10, 0, 12);
        layout.setConstraints(baseUrlLabel, baseLabelConstraints);
        options.add(baseUrlLabel);
        GridBagConstraints baseFieldConstraints = new GridBagConstraints();
        baseFieldConstraints.anchor = 18;
        baseFieldConstraints.gridx = 3;
        baseFieldConstraints.gridy = 0;
        baseFieldConstraints.gridwidth = 4;
        baseFieldConstraints.gridheight = 1;
        baseFieldConstraints.insets = new Insets(0, 10, 0, 6);
        layout.setConstraints(this._baseUrl, baseFieldConstraints);
        options.add(this._baseUrl);
        JLabel dataUrlLabel = new JLabel("Data URL");
        dataUrlLabel.setLabelFor(this._dataUrl);
        GridBagConstraints dataUrlLabelConstraints = new GridBagConstraints();
        dataUrlLabelConstraints.anchor = 18;
        dataUrlLabelConstraints.gridx = 0;
        dataUrlLabelConstraints.gridy = 1;
        dataUrlLabelConstraints.gridwidth = 3;
        dataUrlLabelConstraints.gridheight = 1;
        dataUrlLabelConstraints.insets = new Insets(0, 10, 0, 6);
        layout.setConstraints(dataUrlLabel, dataUrlLabelConstraints);
        options.add(dataUrlLabel);
        GridBagConstraints dataUrlConstraints = new GridBagConstraints();
        dataUrlConstraints.anchor = 18;
        dataUrlConstraints.gridx = 3;
        dataUrlConstraints.gridy = 1;
        dataUrlConstraints.gridwidth = 3;
        dataUrlConstraints.gridheight = 1;
        dataUrlConstraints.insets = new Insets(0, 10, 0, 6);
        layout.setConstraints(this._dataUrl, dataUrlConstraints);
        options.add(this._dataUrl);
        JButton chooseDataButton = this.createChooseDataButton();
        GridBagConstraints chooseDataButtonConstraints = new GridBagConstraints();
        chooseDataButtonConstraints.anchor = 18;
        chooseDataButtonConstraints.gridx = 10;
        chooseDataButtonConstraints.gridy = 1;
        chooseDataButtonConstraints.gridwidth = 3;
        chooseDataButtonConstraints.gridheight = 1;
        chooseDataButtonConstraints.insets = new Insets(0, 10, 0, 6);
        layout.setConstraints(chooseDataButton, chooseDataButtonConstraints);
        options.add(chooseDataButton);
        GridBagConstraints runButtonConstraints = new GridBagConstraints();
        JButton executeButton = this.createRunQueryButton();
        runButtonConstraints.gridx = 2;
        runButtonConstraints.gridy = 4;
        runButtonConstraints.gridwidth = 2;
        runButtonConstraints.gridheight = 1;
        runButtonConstraints.anchor = 14;
        runButtonConstraints.insets = new Insets(5, 10, 0, 6);
        layout.setConstraints(executeButton, runButtonConstraints);
        options.add(executeButton);
        return options;
    }

    private JPanel createResultsPanel() {
        this._resultsPanel = new JPanel(new CardLayout());
        JPanel results = new JPanel(new BorderLayout());
        this._results.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this._results);
        results.add((Component)scrollPane, "Center");
        results.add((Component)this._statusBar, "South");
        this._resultsPanel.add((Component)results, "text");
        JScrollPane tableScrollPane = new JScrollPane(this._resultsTable);
        this._resultsPanel.add((Component)tableScrollPane, "table");
        return this._resultsPanel;
    }

    public void showResultsPanel(String card) {
        CardLayout cards = (CardLayout)this._resultsPanel.getLayout();
        cards.show(this._resultsPanel, card);
    }

    public JTextArea getQueryBox() {
        return this._query;
    }

    public JTextArea getResultsBox() {
        return this._results;
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(MenuFactory.createFileMenu());
        menuBar.add(MenuFactory.createEditMenu());
        menuBar.add(MenuFactory.createSourceMenu());
        menuBar.add(MenuFactory.createResultsMenu());
        this.setJMenuBar(menuBar);
    }

    private JButton createRunQueryButton() {
        JButton runQuery = new JButton("Run Query");
        runQuery.setToolTipText("Run the current query");
        runQuery.addActionListener(new RunQueryCommand());
        return runQuery;
    }

    private JButton createChooseDataButton() {
        JButton chooseDataButton = new JButton("File...");
        chooseDataButton.setToolTipText("Select local data file");
        chooseDataButton.addActionListener(new ActionListener(){
            final JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));

            public void actionPerformed(ActionEvent e) {
                this.fc.addChoosableFileFilter(FileFilters.getFileFilter("txt", "Text Document"));
                this.fc.addChoosableFileFilter(FileFilters.getFileFilter("xml", "XML Document"));
                this.fc.addChoosableFileFilter(FileFilters.getFileFilter("nt", "N-Triples Document"));
                this.fc.addChoosableFileFilter(FileFilters.getFileFilter("ttl", "Turtle Document"));
                this.fc.addChoosableFileFilter(FileFilters.getFileFilter("n3", "N3 Document"));
                this.fc.addChoosableFileFilter(FileFilters.getFileFilter("rdf", "RDF/XML Document"));
                int result = this.fc.showDialog(Twinkle.ui, "Choose Data File");
                if (result == 0) {
                    File file = this.fc.getSelectedFile();
                    Twinkle.ui.getDataUrlField().setText(file.toURI().toString());
                    Twinkle.showStatusBarMessage("Selected data file " + file.getAbsolutePath());
                }
            }
        });
        return chooseDataButton;
    }

    public JTextField getDataUrlField() {
        return this._dataUrl;
    }

    public JTextField getBaseUrl() {
        return this._baseUrl;
    }

    public UndoManager getUndoManager() {
        return this._undoManager;
    }

    public JLabel getStatusBar() {
        return this._statusBar;
    }

    public JTable getResultsTable() {
        return this._resultsTable;
    }
}

