/*
 * Decompiled with CFR 0.152.
 */
package com.ldodds.sparql;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetTextFormatter;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.util.FileUtils;
import com.ldodds.sparql.AbstractQueryRunner;
import com.ldodds.sparql.JTableResultsSetFormatter;
import com.ldodds.sparql.QueryContext;
import java.io.OutputStream;
import java.io.PrintWriter;

class SelectQueryRunner
extends AbstractQueryRunner {
    public SelectQueryRunner(OutputStream out) {
        super(out);
    }

    public void doQuery(QueryContext context, QueryExecution qe) {
        ResultSetFormatter rsFmt;
        ResultSet results = qe.execSelect();
        results = ResultSetFactory.rewindableResults(results);
        if (context.outputFormat.equals("none")) {
            ResultSetFormatter fmt = new ResultSetFormatter(results, context.query.getPrefixMap());
            fmt.consume();
            fmt.close();
        }
        if (context.outputFormat.equals("rs/graph")) {
            ResultSetFormatter rsFmt2 = new ResultSetFormatter(results, context.query.getPrefixMap());
            Model m = rsFmt2.toModel();
            RDFWriter rdfw = m.getWriter("TURTLE");
            m.setNsPrefix("rs", ResultSetVocab.getURI());
            rdfw.write(m, this._out, null);
            rsFmt2.close();
        }
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)this._out);
        if (context.outputFormat.equals("rs/xml")) {
            rsFmt = new ResultSetFormatter(results, context.query.getPrefixMap());
            rsFmt.outputAsXML(this._out);
            rsFmt.close();
        }
        if (context.outputFormat.equals("rs/text")) {
            rsFmt = new ResultSetFormatter(results, context.query.getPrefixMap());
            rsFmt.outputAsText(this._out);
        }
        ResultSetTextFormatter fmt = null;
        if (context.outputFormat.equals("text")) {
            fmt = new ResultSetTextFormatter(results, context.query.getPrefixMap());
            fmt.printAll(out);
        }
        if (context.outputFormat.equals("tuples")) {
            fmt = new ResultSetTextFormatter(results);
            fmt.dump(out, true);
        }
        if (context.outputFormat.equals("table")) {
            JTableResultsSetFormatter tableFormatter = new JTableResultsSetFormatter();
            tableFormatter.display(results);
        }
        if (out != null) {
            out.flush();
        }
        if (fmt != null) {
            fmt.close();
        }
        results.close();
        if (context.query.getQueryBlock().getDataSource() != null) {
            context.query.getQueryBlock().getDataSource().close();
        }
    }
}

