/*
 * Decompiled with CFR 0.152.
 */
package com.ldodds.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.util.FileManager;
import com.ldodds.sparql.AbstractQueryRunner;
import com.ldodds.sparql.QueryContext;
import com.ldodds.sparql.QueryRunner;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunQuery {
    public static final String FMT_NONE = "none";
    public static final String FMT_TUPLES = "tuples";
    public static final String FMT_TEXT = "text";
    public static final String FMT_RS_RDF = "rs/graph";
    public static final String FMT_RS_TEXT = "rs/text";
    public static final String FMT_RS_XML = "rs/xml";
    private Log _log;
    private OutputStream _out;
    private QueryContext _context;
    static /* synthetic */ Class class$0;

    public RunQuery(QueryContext context) {
        this(System.out, context);
    }

    public RunQuery(OutputStream out, QueryContext context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ldodds.sparql.RunQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this._out = out;
        this._context = context;
    }

    public void query() throws QueryException {
        this.addDataSourceToContext();
        this.createQuery();
        this.bindData();
        if (this._context.query.getDataSet() == null && this._context.query.getSourceURIs() == null && this._context.query.getNamedSourceURIs() == null) {
            throw new QueryException("No dataset specified");
        }
        this.execute();
    }

    private void addDataSourceToContext() throws QueryException {
        try {
            if (this._context.fileManager == null) {
                this._context.fileManager = FileManager.get();
            }
            if (this._context.dataURL != null) {
                this._context.model = this._context.fileManager.loadModel(this._context.dataURL, this._context.baseURI, this._context.dataSyntax);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new QueryException("Error loading URL", ex);
        }
    }

    void createQuery() throws QueryException {
        if (this._context.query == null) {
            this._context.query = this.parseQuery(this._context.queryString, this._context.syntax);
        }
        if (this._context.baseURI != null) {
            this._context.query.setBaseURI(this._context.baseURI);
        }
    }

    private void bindData() {
        if (this._context.model != null) {
            this._context.query.setDataSet(this._context.model);
        }
    }

    private void execute() throws QueryException {
        try {
            QueryExecution qe = QueryFactory.createQueryExecution(this._context.query);
            if (this._context.fileManager != null) {
                qe.setFileManager(this._context.fileManager);
            }
            qe.init();
            QueryRunner runner = AbstractQueryRunner.getQueryRunner(this._context.query, this._out);
            runner.doQuery(this._context, qe);
            qe.close();
        }
        catch (ARQInternalErrorException intEx) {
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
            throw intEx;
        }
        catch (QueryException qEx) {
            qEx.printStackTrace();
            throw qEx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new QueryException("Unexpected error executing query", ex);
        }
    }

    private Query parseQuery(String queryString, String syntax) throws QueryException {
        try {
            Query query = Query.create(queryString, syntax);
            return query;
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
            throw intEx;
        }
        catch (QueryException qEx) {
            qEx.printStackTrace();
            throw qEx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new QueryException("Unexpected error parsing query", ex);
        }
    }
}

