/*
 * Decompiled with CFR 0.152.
 */
package com.ldodds.sparql;

import com.hp.hpl.jena.util.FileManager;
import com.ldodds.sparql.Twinkle;
import com.ldodds.util.FileFilters;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class MenuFactory {
    private static int META_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        JMenuItem openMenuItem = new JMenuItem("Open Query");
        openMenuItem.setMnemonic(79);
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, META_KEY));
        openMenuItem.addActionListener(new OpenQueryAction());
        menu.add(openMenuItem);
        JMenuItem saveMenuItem = new JMenuItem("Save Query");
        saveMenuItem.setMnemonic(83);
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, META_KEY));
        saveMenuItem.addActionListener(new SaveQueryAction());
        menu.add(saveMenuItem);
        JMenuItem saveResultsMenuItem = new JMenuItem("Save Results");
        saveResultsMenuItem.setMnemonic(65);
        saveResultsMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, META_KEY));
        saveResultsMenuItem.addActionListener(new SaveResultsAction());
        menu.add(saveResultsMenuItem);
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.setMnemonic(88);
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(exitMenuItem);
        return menu;
    }

    public static JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        JMenuItem undoMenuItem = new JMenuItem("Undo");
        undoMenuItem.setMnemonic(85);
        undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, META_KEY));
        undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Twinkle.ui.getUndoManager().undo();
                }
                catch (CannotUndoException ex) {
                    Twinkle.ui.getToolkit().beep();
                }
            }
        });
        menu.add(undoMenuItem);
        JMenuItem redoMenuItem = new JMenuItem("Redo");
        redoMenuItem.setMnemonic(82);
        redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, META_KEY));
        redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Twinkle.ui.getUndoManager().redo();
                }
                catch (CannotRedoException ex) {
                    Twinkle.ui.getToolkit().beep();
                }
            }
        });
        menu.add(redoMenuItem);
        JMenuItem cutMenuItem = new JMenuItem("Cut");
        cutMenuItem.setMnemonic(88);
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, META_KEY));
        cutMenuItem.addActionListener(Twinkle.ui.getQueryBox().getActionMap().get("cut-to-clipboard"));
        menu.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy");
        copyMenuItem.setMnemonic(67);
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, META_KEY));
        copyMenuItem.addActionListener(Twinkle.ui.getQueryBox().getActionMap().get("copy-to-clipboard"));
        menu.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste");
        pasteMenuItem.setMnemonic(86);
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, META_KEY));
        pasteMenuItem.addActionListener(Twinkle.ui.getQueryBox().getActionMap().get("paste-from-clipboard"));
        menu.add(pasteMenuItem);
        return menu;
    }

    public static JMenu createSourceMenu() {
        JMenu menu = new JMenu("Source");
        menu.setMnemonic(83);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rdfXML = new JRadioButtonMenuItem("RDF/XML");
        rdfXML.setActionCommand("RDF/XML");
        rdfXML.setSelected(true);
        group.add(rdfXML);
        menu.add(rdfXML);
        JRadioButtonMenuItem ntriples = new JRadioButtonMenuItem("N-Triples");
        ntriples.setActionCommand("N-TRIPLE");
        group.add(ntriples);
        menu.add(ntriples);
        JRadioButtonMenuItem turtle = new JRadioButtonMenuItem("Turtle");
        turtle.setActionCommand("TURTLE");
        group.add(turtle);
        menu.add(turtle);
        JRadioButtonMenuItem nthree = new JRadioButtonMenuItem("N3");
        nthree.setActionCommand("N3");
        group.add(nthree);
        menu.add(nthree);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Twinkle.context.dataSyntax = e.getActionCommand();
                Twinkle.showStatusBarMessage("Data syntax set to " + e.getActionCommand());
            }
        };
        rdfXML.addActionListener(listener);
        ntriples.addActionListener(listener);
        turtle.addActionListener(listener);
        nthree.addActionListener(listener);
        return menu;
    }

    public static JMenu createResultsMenu() {
        JMenu menu = new JMenu("Results");
        menu.setMnemonic(82);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem text = new JRadioButtonMenuItem("Text");
        text.setActionCommand("text");
        text.setSelected(true);
        group.add(text);
        menu.add(text);
        JRadioButtonMenuItem xml = new JRadioButtonMenuItem("XML");
        xml.setActionCommand("rs/xml");
        group.add(xml);
        menu.add(xml);
        JRadioButtonMenuItem table = new JRadioButtonMenuItem("Table");
        table.setActionCommand("table");
        group.add(table);
        menu.add(table);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Twinkle.context.outputFormat = e.getActionCommand();
                Twinkle.showStatusBarMessage("Results format set to " + e.getActionCommand());
                if ("table".equals(e.getActionCommand())) {
                    Twinkle.ui.showResultsPanel("table");
                } else {
                    Twinkle.ui.showResultsPanel("text");
                }
            }
        };
        text.addActionListener(listener);
        xml.addActionListener(listener);
        table.addActionListener(listener);
        return menu;
    }

    private static final class OpenQueryAction
    extends AbstractAction {
        private JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));

        public OpenQueryAction() {
            this.fc.setDialogTitle("Open Query");
            this.fc.addChoosableFileFilter(FileFilters.getFileFilter("txt", "Text Files"));
            this.fc.addChoosableFileFilter(FileFilters.getFileFilter("rq", "Sparql Queries"));
        }

        public void actionPerformed(ActionEvent e) {
            int result = this.fc.showOpenDialog(Twinkle.ui);
            if (result == 0) {
                File queryFile = this.fc.getSelectedFile();
                try {
                    FileInputStream fin = new FileInputStream(queryFile);
                    String query = FileManager.get().readWholeFileAsUTF8((InputStream)fin);
                    Twinkle.ui.getQueryBox().setText(query);
                    Twinkle.showStatusBarMessage("Loaded Query " + queryFile.getAbsolutePath());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private static abstract class SaveAction
    extends AbstractAction {
        private JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));

        public void actionPerformed(ActionEvent e) {
            this.fc.setDialogTitle(this.getDialogTitle());
            this.addFileFilters(this.fc);
            int result = this.fc.showSaveDialog(Twinkle.ui);
            if (result == 0) {
                File queryFile = this.fc.getSelectedFile();
                try {
                    FileOutputStream fout = new FileOutputStream(queryFile);
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF-8");
                    out.write(this.getTextToSave());
                    out.flush();
                    out.close();
                    Twinkle.showStatusBarMessage("Saved to " + queryFile.getAbsolutePath());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        abstract String getTextToSave();

        abstract String getDialogTitle();

        abstract void addFileFilters(JFileChooser var1);
    }

    private static final class SaveQueryAction
    extends SaveAction {
        SaveQueryAction() {
        }

        String getTextToSave() {
            return Twinkle.ui.getQueryBox().getText();
        }

        String getDialogTitle() {
            return "Save Query";
        }

        void addFileFilters(JFileChooser fc) {
            fc.addChoosableFileFilter(FileFilters.getFileFilter("txt", "Text Files"));
            fc.addChoosableFileFilter(FileFilters.getFileFilter("rq", "Sparql Queries"));
        }
    }

    private static final class SaveResultsAction
    extends SaveAction {
        SaveResultsAction() {
        }

        String getTextToSave() {
            return Twinkle.ui.getResultsBox().getText();
        }

        String getDialogTitle() {
            return "Save Results";
        }

        void addFileFilters(JFileChooser fc) {
            fc.addChoosableFileFilter(FileFilters.getFileFilter("txt", "Text Files"));
            fc.addChoosableFileFilter(FileFilters.getFileFilter("xml", "XML Documents"));
            fc.addChoosableFileFilter(FileFilters.getFileFilter("rdf", "RDF/XML Documents"));
        }
    }
}

