/*
 * Decompiled with CFR 0.152.
 */
package com.ldodds.sparql;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.ldodds.sparql.Twinkle;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class JTableResultsSetFormatter {
    public void display(ResultSet results) {
        JTable table = Twinkle.ui.getResultsTable();
        DefaultTableModel tableModel = new DefaultTableModel(this.getData(results), this.getColumns(results));
        table.setModel(tableModel);
        table.repaint();
    }

    private Vector getData(ResultSet data) {
        Vector<Vector> results = new Vector<Vector>();
        while (data.hasNext()) {
            QuerySolution qs = data.nextSolution();
            results.add(this.getRowData(data, qs));
        }
        return results;
    }

    private Vector getRowData(ResultSet results, QuerySolution qs) {
        Vector<String> row = new Vector<String>();
        Iterator iter = results.getResultVars().iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            row.add(this.getValueAsString(qs, var));
        }
        return row;
    }

    private String getValueAsString(QuerySolution qs, String var) {
        RDFNode result = qs.get(var);
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    private Vector getColumns(ResultSet results) {
        Vector cols = new Vector();
        cols.addAll(results.getResultVars());
        return cols;
    }
}

