/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class QueryPrintUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static int bNodeCounter = 0;
    static Map bNodeStrings = new HashMap();
    static PrefixMapping prefixes = PrefixMapping.Factory.create().setNsPrefixes(PrefixMapping.Standard).setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");

    public static String stringForObject(Object object) {
        if (object == null) {
            return "<<null>>";
        }
        if (object instanceof RDFNode) {
            return QueryPrintUtils.stringForRDFNode((RDFNode)object);
        }
        if (object instanceof Node) {
            return QueryPrintUtils.stringForNode((Node)object);
        }
        return object.toString();
    }

    public static String stringForRDFNode(RDFNode rDFNode) {
        return QueryPrintUtils.stringForRDFNode(rDFNode, null);
    }

    public static String stringForRDFNode(RDFNode rDFNode, PrefixMapping prefixMapping) {
        if (rDFNode == null) {
            return "<<null>>";
        }
        if (rDFNode instanceof Literal) {
            return QueryPrintUtils.stringForLiteral((Literal)rDFNode, prefixMapping);
        }
        if (rDFNode instanceof Resource) {
            return QueryPrintUtils.stringForResource((Resource)rDFNode, prefixMapping);
        }
        return rDFNode.toString();
    }

    public static String stringForLiteral(Literal literal, PrefixMapping prefixMapping) {
        return QueryPrintUtils.stringForLiteralLabel(literal.asNode().getLiteral(), prefixMapping);
    }

    public static String stringForLiteralLabel(LiteralLabel literalLabel, PrefixMapping prefixMapping) {
        String string = literalLabel.getDatatypeURI();
        String string2 = literalLabel.language();
        String string3 = literalLabel.getLexicalForm();
        if (string != null) {
            if (string.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(string3);
                    return string3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string.equals(XSD.xdouble.getURI()) && (string3.indexOf(46) >= 0 || string3.indexOf(101) >= 0 || string3.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(string3);
                    return string3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(string3);
        stringBuffer.append("\"");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("@");
            stringBuffer.append(string2);
        }
        if (string != null) {
            stringBuffer.append("^^");
            stringBuffer.append(QueryPrintUtils.stringForURI(string, prefixMapping));
        }
        return stringBuffer.toString();
    }

    public static String stringForResource(Resource resource) {
        return QueryPrintUtils.stringForResource(resource, (PrefixMapping)resource.getModel());
    }

    public static String stringForResource(Resource resource, PrefixMapping prefixMapping) {
        return QueryPrintUtils.stringForNode(resource.getNode(), prefixMapping);
    }

    public static String stringForNode(Node node) {
        return QueryPrintUtils.stringForNode(node, null);
    }

    public static String stringForNode(Node node, PrefixMapping prefixMapping) {
        if (node == null) {
            return "<<null>>";
        }
        if (node.isBlank()) {
            AnonId anonId = node.getBlankNodeId();
            if (!bNodeStrings.containsKey(anonId)) {
                bNodeStrings.put(anonId, "_:b" + bNodeCounter++);
            }
            return (String)bNodeStrings.get(anonId);
        }
        if (node.isLiteral()) {
            LiteralLabel literalLabel = node.getLiteral();
            return QueryPrintUtils.stringForLiteralLabel(literalLabel, prefixMapping);
        }
        if (node.isURI()) {
            String string = node.getURI();
            return QueryPrintUtils.stringForURI(string, prefixMapping);
        }
        if (node.isVariable()) {
            return "?" + node.getName();
        }
        return node.toString();
    }

    private static String stringForURI(String string, PrefixMapping prefixMapping) {
        String string2;
        if (prefixMapping != null && (string2 = prefixMapping.shortForm(string)) != null && !string2.equals(string)) {
            return string2;
        }
        return "<" + string + ">";
    }
}

