/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.Iterator;
import java.util.Map;

public class PrefixMapping2
implements PrefixMapping {
    PrefixMapping pmapGlobal;
    PrefixMapping pmapLocal;

    public PrefixMapping2(PrefixMapping prefixMapping, PrefixMapping prefixMapping2) {
        this.pmapGlobal = prefixMapping;
        this.pmapLocal = prefixMapping2;
    }

    public PrefixMapping2(PrefixMapping prefixMapping) {
        this(prefixMapping, (PrefixMapping)new PrefixMappingImpl());
    }

    public PrefixMapping getLocalPrefixMapping() {
        return this.pmapLocal;
    }

    public PrefixMapping getGlobalPrefixMapping() {
        return this.pmapLocal;
    }

    public PrefixMapping setNsPrefix(String string, String string2) {
        this.pmapLocal.setNsPrefix(string, string2);
        return this;
    }

    public PrefixMapping removeNsPrefix(String string) {
        this.pmapLocal.removeNsPrefix(string);
        if (this.pmapGlobal.getNsPrefixURI(string) != null) {
            throw new UnsupportedOperationException("PrefixMapping2: prefix '" + string + "' in the immutable map");
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping prefixMapping) {
        this.pmapLocal.setNsPrefixes(prefixMapping);
        return this;
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.pmapLocal.setNsPrefixes(map);
        return this;
    }

    public String getNsPrefixURI(String string) {
        String string2 = this.pmapLocal.getNsPrefixURI(string);
        if (string2 != null) {
            return string2;
        }
        return this.pmapGlobal.getNsPrefixURI(string);
    }

    public String getNsURIPrefix(String string) {
        String string2 = this.pmapLocal.getNsURIPrefix(string);
        if (string2 != null) {
            return string2;
        }
        return this.pmapGlobal.getNsURIPrefix(string);
    }

    public Map getNsPrefixMap() {
        Map map = this.pmapLocal.getNsPrefixMap();
        Map map2 = this.pmapLocal.getNsPrefixMap();
        map.putAll(map2);
        return map;
    }

    public String expandPrefix(String string) {
        String string2 = this.pmapLocal.expandPrefix(string);
        if (string2 == null || string2.equals(string)) {
            string2 = this.pmapGlobal.expandPrefix(string);
        }
        return string2;
    }

    public String shortForm(String string) {
        String string2 = this.pmapLocal.shortForm(string);
        if (string2 == null || string2.equals(string)) {
            string2 = this.pmapGlobal.shortForm(string);
        }
        return string2;
    }

    public String usePrefix(String string) {
        String string2 = this.pmapLocal.qnameFor(string);
        if (string2 != null) {
            return string2;
        }
        return this.pmapGlobal.qnameFor(string);
    }

    public String qnameFor(String string) {
        String string2 = this.pmapLocal.qnameFor(string);
        if (string2 != null) {
            return string2;
        }
        return this.pmapGlobal.qnameFor(string);
    }

    public PrefixMapping lock() {
        this.pmapLocal.lock();
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping prefixMapping) {
        Iterator iterator = prefixMapping.getNsPrefixMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (this.getNsPrefixURI(string) != null || this.getNsURIPrefix(string2) != null) continue;
            this.setNsPrefix(string, string2);
        }
        return this;
    }
}

