/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentedWriter {
    PrintWriter out;
    int currentIndent = 0;
    int column = 0;
    int row = 1;
    boolean lineNumbers = false;
    boolean startingNewLine = true;
    private static int WidthLineNumber = 3;

    public IndentedWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public IndentedWriter(OutputStream outputStream, boolean bl) {
        this(FileUtils.asPrintWriterUTF8((OutputStream)outputStream), bl);
    }

    IndentedWriter(Writer writer) {
        this(new PrintWriter(writer), false);
    }

    IndentedWriter(Writer writer, boolean bl) {
        this(new PrintWriter(writer), bl);
    }

    IndentedWriter(PrintWriter printWriter) {
        this(printWriter, false);
    }

    IndentedWriter(PrintWriter printWriter, boolean bl) {
        this.out = printWriter;
        this.lineNumbers = bl;
        this.startingNewLine = true;
    }

    public void print(String string) {
        this.lineStart();
        this.out.print(string);
        this.column += string.length();
    }

    public void print(char c) {
        this.lineStart();
        this.out.print(c);
        ++this.column;
    }

    public void println(String string) {
        this.print(string);
        this.newline();
    }

    public void println(char c) {
        this.print(c);
        this.newline();
    }

    public void println() {
        this.newline();
    }

    public void newline() {
        this.out.println();
        this.startingNewLine = true;
        ++this.row;
        this.column = 0;
        this.flush();
    }

    public void flush() {
        this.out.flush();
    }

    public void pad() {
        if (this.startingNewLine && this.currentIndent > 0) {
            this.lineStart();
        }
        this.padInt();
    }

    private void padInt() {
        for (int i = this.column; i < this.currentIndent; ++i) {
            this.out.print(' ');
            ++this.column;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.column;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public void incIndent(int n) {
        this.currentIndent += n;
    }

    public void decIndent(int n) {
        this.currentIndent -= n;
    }

    public void setIndent(int n) {
        this.currentIndent = n;
    }

    private void lineStart() {
        if (this.startingNewLine) {
            this.insertLineNumber();
        }
        this.padInt();
        this.startingNewLine = false;
    }

    private void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String string = Integer.toString(this.row);
        for (int i = 0; i < WidthLineNumber - string.length(); ++i) {
            this.out.print(' ');
        }
        this.out.print(string);
        this.out.print(' ');
    }
}

