/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ClosableIteratorIterator
implements ClosableIterator {
    private boolean finished = false;
    private Iterator iterators;
    private ClosableIterator currentSubIterator;

    public ClosableIteratorIterator(Iterator iterator) {
        this.iterators = iterator;
        this.currentSubIterator = null;
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.currentSubIterator == null) {
            this.currentSubIterator = this.nextIterator();
        }
        if (this.currentSubIterator == null) {
            return false;
        }
        while (!this.currentSubIterator.hasNext()) {
            this.currentSubIterator.close();
            this.currentSubIterator = this.nextIterator();
            if (this.currentSubIterator != null) continue;
            return false;
        }
        return true;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentSubIterator.next();
    }

    public void close() {
        if (this.finished) {
            return;
        }
        while (this.currentSubIterator != null) {
            this.currentSubIterator.close();
            this.currentSubIterator = this.nextIterator();
        }
    }

    private ClosableIterator nextIterator() {
        if (this.iterators.hasNext()) {
            return (ClosableIterator)this.iterators.next();
        }
        this.finished = true;
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }
}

