/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.expr.ExprBoolean;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNumeric;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import java.io.ByteArrayInputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExpressionsARQ
extends TestSuite {
    static final String testSetName = "ARQ - Expressions";

    public static TestSuite suite() {
        return new TestExpressionsARQ(testSetName);
    }

    private TestExpressionsARQ(String string) {
        super(string);
        String string2 = "http://www.w3.org/2001/XMLSchema#";
        this.addTest((Test)new TestNumeric("7", 7L));
        this.addTest((Test)new TestNumeric("-3", -3L));
        this.addTest((Test)new TestNumeric("+2", 2L));
        this.addTest((Test)new TestNumeric("3+4+5", 12L));
        this.addTest((Test)new TestNumeric("(3+4)+5", 12L));
        this.addTest((Test)new TestNumeric("3+(4+5)", 12L));
        this.addTest((Test)new TestNumeric("3*4+5", 17L));
        this.addTest((Test)new TestNumeric("3*(4+5)", 27L));
        this.addTest((Test)new TestNumeric("10-3-5", 2L));
        this.addTest((Test)new TestNumeric("(10-3)-5", 2L));
        this.addTest((Test)new TestNumeric("10-(3-5)", 12L));
        this.addTest((Test)new TestNumeric("10-3+5", 12L));
        this.addTest((Test)new TestNumeric("10-(3+5)", 2L));
        this.addTest((Test)new TestNumeric("1.5 + 2.5", 4.0));
        this.addTest((Test)new TestNumeric("1.5 + 2", 3.5));
        this.addTest((Test)new TestNumeric("4111222333444", 4111222333444L));
        this.addTest((Test)new TestNumeric("1234 + 4111222333444", 4111222334678L));
        this.addTest((Test)new TestBoolean("2 < 3", false, true));
        this.addTest((Test)new TestBoolean("2 > 3", false, false));
        this.addTest((Test)new TestBoolean("(2 < 3) && (3<4)", false, true));
        this.addTest((Test)new TestBoolean("(2 < 3) && (3>=4)", false, false));
        this.addTest((Test)new TestBoolean("(2 < 3) || (3>=4)", false, true));
        this.addTest((Test)new TestBoolean("2 == 3", false, false));
        this.addTest((Test)new TestBoolean("2 < '3'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" ne \"joe\"", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq \"joe\"", false, false));
        this.addTest((Test)new TestBoolean("\"fred\" eq \"fred\"", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq 'fred'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" eq 'fr\\ed'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\" ne \"fred\"", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'^^<type1>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'joe'^^<type1>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'^^<type2>", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'fred'^^<type2>", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<" + string2 + "string> eq 'fred'", false, true));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> eq 'fred'", false, false));
        this.addTest((Test)new TestBoolean("'fred'^^<type1> ne 'fred'", false, true));
        this.addTest((Test)new TestBoolean("'21'^^<int> == '21'", false, true));
        this.addTest((Test)new TestBoolean("\"fred\\1\" eq 'fred1'", false, true));
        this.addTest((Test)new TestBoolean("\"fred2\" eq 'fred\\2'", false, true));
        this.addTest((Test)new TestBoolean("'fred\\\\3' ne \"fred3\"", false, true));
        this.addTest((Test)new TestBoolean("\"urn:fred\" eq <urn:fred>", false, true));
        this.addTest((Test)new TestBoolean("\"urn:fred\" ne <urn:fred>", false, false));
        this.addTest((Test)new TestBoolean("\"urn:fred/1.5\" ne <urn:fred/1.5>", false, false));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /abbc/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /a..c/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /^aabb/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" =~ /cc$/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" !~ /abbc/", false, false));
        this.addTest((Test)new TestBoolean("\"aab*bcc\" =~ /ab\\*bc/", false, true));
        this.addTest((Test)new TestBoolean("\"aabbcc\" ~~ /ab\\\\*bc/", false, true));
        this.addTest((Test)new TestBoolean("'aabbcc' =~ /B.*B/i", false, true));
        this.addTest((Test)new TestBoolean("1.5 < 2", false, true));
        this.addTest((Test)new TestBoolean("1.5 > 2", false, false));
        this.addTest((Test)new TestBoolean("1.5 < 2.3", false, true));
        this.addTest((Test)new TestBoolean("1.5 > 2.3", false, false));
        this.addTest((Test)new TestBoolean("4111222333444 > 1234", false, true));
        this.addTest((Test)new TestBoolean("4111222333444 < 1234", false, false));
        this.addTest((Test)new TestBoolean("2 < \"fred\"", true, false));
    }

    static class TestBoolean
    extends TestCase {
        String s;
        boolean failureCorrect;
        boolean rightAnswer;

        TestBoolean(String string, boolean bl, boolean bl2) {
            super("Boolean test : " + string + " ");
            this.s = string;
            this.failureCorrect = bl;
            this.rightAnswer = bl2;
        }

        protected void runTest() throws Throwable {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.s.getBytes());
            ARQParser aRQParser = new ARQParser(byteArrayInputStream);
            ExprNode exprNode = null;
            try {
                exprNode = aRQParser.Expression();
            }
            catch (Error error) {
                TestCase.fail((String)("Error throw in parse: " + error));
            }
            TestBoolean.assertTrue((String)("Expression is not ExprBoolean: " + exprNode.getClass().getName()), (exprNode instanceof ExprBoolean || exprNode instanceof NodeValue && ((NodeValue)exprNode).isBoolean() ? 1 : 0) != 0);
            ExprBoolean exprBoolean = (ExprBoolean)((Object)exprNode);
            NodeValue nodeValue = null;
            boolean bl = false;
            try {
                nodeValue = exprBoolean.eval(null, null);
                bl = nodeValue.getBoolean();
            }
            catch (ExprEvalException exprEvalException) {
                if (!this.failureCorrect) {
                    throw exprEvalException;
                }
                bl = false;
            }
            TestBoolean.assertEquals((String)(this.s + " => " + bl + " [" + this.rightAnswer + "]"), (boolean)bl, (boolean)this.rightAnswer);
        }
    }

    static class TestNumeric
    extends TestCase {
        String s;
        boolean isDouble = false;
        long rightAnswer;
        double rightAnswerDouble;

        TestNumeric(String string, long l) {
            super("Numeric test : " + string + " ");
            this.s = string;
            this.rightAnswer = l;
            this.isDouble = false;
        }

        TestNumeric(String string, double d) {
            super("Numeric test : " + string + " ");
            this.s = string;
            this.rightAnswerDouble = d;
            this.isDouble = true;
        }

        protected void runTest() throws Throwable {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.s.getBytes());
            ARQParser aRQParser = new ARQParser(byteArrayInputStream);
            ExprNode exprNode = null;
            try {
                exprNode = aRQParser.Expression();
            }
            catch (Error error) {
                TestNumeric.fail((String)("Error thrown in parse: " + error));
            }
            TestNumeric.assertTrue((String)("Expression is not numeric: " + exprNode), (exprNode instanceof ExprNumeric || exprNode instanceof NodeValue && ((NodeValue)exprNode).isNumber() ? 1 : 0) != 0);
            NodeValue nodeValue = exprNode.eval(null, null);
            if (!this.isDouble) {
                TestNumeric.assertEquals((String)(this.s + " => " + nodeValue.getInt() + " [" + this.rightAnswer + "]"), (long)nodeValue.getInt(), (long)this.rightAnswer);
            } else {
                TestNumeric.assertEquals((String)(this.s + " => " + nodeValue.getDouble() + " [" + this.rightAnswerDouble + "]"), (double)nodeValue.getDouble(), (double)this.rightAnswerDouble, (double)1.0E-4);
            }
        }
    }
}

