/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.test.QueryTestScripts;
import com.hp.hpl.jena.rdf.model.Model;
import junit.framework.Test;
import junit.framework.TestSuite;

public class QueryTestScriptsManifest
extends QueryTestScripts {
    static final String testSetNameRDQL = "RDQL - Scripts";
    static final String testSetNameARQ = "ARQ  - Scripts";
    static final String testSetNameDAWG = "DAWG - Misc";
    static final String testSetNameWGApproved = "DAWG - Approved";
    static final String testSetNameWGPending = "DAWG - Pending";
    public static final String testDirRDQL = "testing/RDQL";
    public static final String testDirARQ = "testing/ARQ";
    public static final String testDirDAWG = "testing/DAWG";
    public static final String testDirWGApproved = "testing/WG-Approved";
    public static final String testDirWGPending = "testing/WG-Pending";
    public static final String controlFilenameRDQL = "testing/RDQL/manifest-rdql.n3";
    public static final String controlFilenameARQ = "testing/ARQ/manifest-arq.n3";
    public static final String controlFilenameDAWG = "testing/DAWG/manifest-dawg.n3";

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("ARQ - Scripted tests");
        testSuite.addTest((Test)QueryTestScriptsManifest.makeRDQLTests());
        testSuite.addTest((Test)QueryTestScriptsManifest.makeARQTests());
        testSuite.addTest((Test)QueryTestScriptsManifest.makeDAWGTests());
        return testSuite;
    }

    public static TestSuite makeRDQLTests() {
        return new QueryTestScriptsManifest(testSetNameRDQL, testDirRDQL, controlFilenameRDQL);
    }

    public static TestSuite makeARQTests() {
        return new QueryTestScriptsManifest(testSetNameARQ, testDirARQ, controlFilenameARQ);
    }

    public static TestSuite makeDAWGTests() {
        return new QueryTestScriptsManifest(testSetNameDAWG, testDirDAWG, controlFilenameDAWG);
    }

    public static TestSuite makeWGTestsApproved() {
        TestSuite testSuite = new TestSuite(testSetNameWGApproved);
        testSuite.addTest((Test)QueryTestScriptsManifest.makeWGTestSuite("testing/WG-Approved/simple/manifest.n3", "simple"));
        testSuite.addTest((Test)QueryTestScriptsManifest.makeWGTestSuite("testing/WG-Approved/examples/manifest.n3", "examples"));
        return testSuite;
    }

    public static TestSuite makeWGTestsPending() {
        TestSuite testSuite = new TestSuite(testSetNameWGPending);
        return testSuite;
    }

    public static TestSuite makeWGTestSuite(String string, String string2) {
        return new QueryTestScriptsManifest(string, null, string);
    }

    public QueryTestScriptsManifest(String string, String string2, String string3) {
        this(string, null, string2, string3);
    }

    QueryTestScriptsManifest(String string, Model model, String string2, String string3) {
        super(string);
        this.addTests(model, string3, string2);
    }
}

