/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetTextFormatter;
import com.hp.hpl.jena.query.core.DataSource1;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.test.TestItem;
import com.hp.hpl.jena.query.test.TestManifestList;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTestScripts
extends TestSuite {
    public String basename = null;
    protected static Log log = LogFactory.getLog((Class)QueryTestScripts.class);
    static int arqTestCounter = 0;

    public QueryTestScripts(String string) {
        super(string);
    }

    public void addTest(TestItem testItem) {
        this.addTest("ARQ-test-" + ++arqTestCounter, testItem);
    }

    public void addTest(String string, TestItem testItem) {
        this.addTest(string, null, testItem);
    }

    public void addTest(String string, String string2, TestItem testItem) {
        this.addTest(null, string, string2, testItem);
    }

    public void addTest(Model model, String string, String string2, TestItem testItem) {
        FileManager fileManager = FileManager.get();
        if (string2 != null) {
            fileManager = new FileManager();
            fileManager.addLocatorFile(string2);
        }
        QueryTest queryTest = new QueryTest(model, string, fileManager, testItem);
        this.addTest((Test)queryTest);
    }

    protected void addTests(Model model, String string, String string2) {
        PrintStream printStream = System.out;
        Model model2 = null;
        try {
            model2 = FileManager.get().loadModel(string);
        }
        catch (JenaException jenaException) {
            log.warn((Object)("Problems loading " + string + ": " + jenaException.getMessage()));
            return;
        }
        catch (Exception exception) {
            log.warn((Object)("Problems loading " + string), (Throwable)exception);
            return;
        }
        TestManifestList testManifestList = new TestManifestList(model2);
        TestManifestList.TestIterator testIterator = testManifestList.iterator();
        while (testIterator.hasNext()) {
            TestItem testItem = testIterator.nextItem();
            this.addTest(model, testItem.getName(), string2, testItem);
        }
    }

    public static void emptyModel(Model model) {
        if (model == null) {
            return;
        }
        try {
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
            stmtIterator.close();
        }
        catch (JenaException jenaException) {
            log.error((Object)"Failed to empty model (com.hp.hpl.jena.rdf.query.Test.QueryTest.emptyModel)", (Throwable)jenaException);
        }
    }

    static String convertFilename(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if (string2 != null && !string.startsWith("/")) {
            string = string2 + "/" + string;
        }
        return string;
    }

    static String formatlong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(l));
        for (int i = stringBuffer.length(); i < 4; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static class QueryTest
    extends TestCase {
        static int testCounter = 1;
        static boolean printModelsOnFailure = false;
        Model model;
        int testNumber = testCounter++;
        TestItem testItem;
        FileManager queryFileManager;
        String queryString = null;
        Model resultsModel = null;
        String description = null;

        QueryTest(Model model, String string, FileManager fileManager, TestItem testItem) {
            super(string);
            this.model = model;
            this.queryFileManager = fileManager;
            this.testItem = testItem;
        }

        protected void setUp() throws Exception {
            super.setUp();
            this.description = this.makeDescription();
            try {
                if (this.testItem.getQueryFile() == null) {
                    QueryTest.fail((String)"Query test file is null");
                    return;
                }
                this.queryString = FileManager.get().readWholeFileAsUTF8(this.testItem.getQueryFile());
            }
            catch (Exception exception) {
                QueryTest.fail((String)("Failed to read file " + this.testItem.getQueryFile()));
                return;
            }
            if (this.testItem.getResultFile() != null) {
                this.resultsModel = FileManager.get().loadModel(this.testItem.getResultFile());
                if (this.resultsModel.isEmpty()) {
                    log.warn((Object)("Empty results model: " + this.testItem.getResultFile()));
                }
            }
        }

        protected void tearDown() throws Exception {
            super.tearDown();
        }

        private DataSource setUpDataSource(Query query2, TestItem testItem) {
            try {
                if (QueryTest.doesQueryHaveDataset(query2) && testItem.getDataFiles() != null && testItem.getDataFiles().size() > 0) {
                    log.warn((Object)(testItem.name + " : query data source and also in test file"));
                }
                if (testItem.getDataFiles() != null && testItem.getDataFiles().size() != 0) {
                    List list = testItem.getDataFiles();
                    DataSource1 dataSource1 = new DataSource1();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        FileManager.get().readModel(dataSource1.getModel(), string);
                    }
                    return dataSource1;
                }
                if (!QueryTest.doesQueryHaveDataset(query2)) {
                    QueryTest.fail((String)"No data sources");
                }
                return null;
            }
            catch (JenaException jenaException) {
                log.debug((Object)("JenaException: " + jenaException.getMessage()));
                QueryTest.fail((String)("JenaException creating data source: " + jenaException.getMessage()));
                return null;
            }
        }

        private static boolean doesQueryHaveDataset(Query query2) {
            boolean bl = query2.getSourceURIs() != null && query2.getSourceURIs().size() > 0 || query2.getNamedSourceURIs() != null && query2.getNamedSourceURIs().size() > 0;
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws Throwable {
            Query query2 = null;
            try {
                block16: {
                    try {
                        try {
                            query2 = Query.create(this.queryString, this.testItem.getQueryFileSyntax());
                        }
                        catch (QueryException queryException) {
                            query2 = null;
                            QueryTest.fail((String)("Parse failure: " + queryException.getMessage()));
                            throw queryException;
                        }
                        DataSource dataSource = this.setUpDataSource(query2, this.testItem);
                        if (dataSource != null) {
                            if (query2.getQueryBlock() == null) {
                                query2.setQueryBlock(new ElementBlock(dataSource, null));
                            } else {
                                query2.getQueryBlock().setDataSource(dataSource);
                            }
                        }
                        QueryExecution queryExecution = QueryFactory.createQueryExecution(query2, this.queryFileManager);
                        queryExecution.init();
                        if (query2.isSelectType()) {
                            this.runTestSelect(query2, queryExecution);
                            break block16;
                        }
                        if (query2.isConstructType()) {
                            this.runTestConstruct(query2, queryExecution);
                            break block16;
                        }
                        if (query2.isDescribeType()) {
                            this.runTestDescribe(query2, queryExecution);
                            break block16;
                        }
                        if (!query2.isAskType()) break block16;
                        this.runTestAsk(query2, queryExecution);
                    }
                    catch (IOException iOException) {
                        QueryTest.fail((String)("IOException: " + iOException.getMessage()));
                        throw iOException;
                    }
                    catch (Exception exception) {
                        log.debug((Object)("Exception: " + exception.getMessage()));
                        QueryTest.fail((String)("Exception: " + this.testItem.getQueryFile()));
                        Object var5_8 = null;
                        if (this.model == null && query2 != null && query2.getQueryBlock().getDataSource() != null) {
                            query2.getQueryBlock().getDataSource().close();
                        }
                    }
                }
                Object var5_7 = null;
                if (this.model == null && query2 != null && query2.getQueryBlock().getDataSource() != null) {
                    query2.getQueryBlock().getDataSource().close();
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (this.model == null && query2 != null && query2.getQueryBlock().getDataSource() != null) {
                    query2.getQueryBlock().getDataSource().close();
                }
                throw throwable;
            }
        }

        void runTestSelect(Query query2, QueryExecution queryExecution) throws Exception {
            ResultSet resultSet = queryExecution.execSelect();
            ResultSetRewindable resultSetRewindable = ResultSetFactory.rewindableResults(resultSet);
            resultSet.close();
            resultSet = null;
            if (this.resultsModel != null) {
                try {
                    ResultSetRewindable resultSetRewindable2 = ResultSetFactory.rewindableResults(resultSetRewindable);
                    ResultSetRewindable resultSetRewindable3 = ResultSetFactory.makeRewindableResults(this.resultsModel);
                    if (!QueryTest.resultSetEquivalent(resultSetRewindable2, resultSetRewindable3, query2.getPrefixMap())) {
                        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
                        printWriter.println();
                        printWriter.println("=======================================");
                        printWriter.println("Failure: " + this.description);
                        printWriter.println("Got: " + resultSetRewindable2.size() + " --------------------------------");
                        resultSetRewindable2.reset();
                        ResultSetTextFormatter resultSetTextFormatter = new ResultSetTextFormatter(resultSetRewindable2);
                        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSetRewindable2, query2.getPrefixMap());
                        resultSetTextFormatter.dump(printWriter, false);
                        resultSetRewindable2.reset();
                        if (printModelsOnFailure) {
                            printWriter.println("-----------------------------------------");
                            resultSetFormatter.toModel().write((Writer)printWriter, "N3");
                            resultSetRewindable2.reset();
                        }
                        printWriter.flush();
                        ResultSetTextFormatter resultSetTextFormatter2 = new ResultSetTextFormatter(resultSetRewindable3);
                        ResultSetFormatter resultSetFormatter2 = new ResultSetFormatter(resultSetRewindable3, query2.getPrefixMap());
                        printWriter.println("Expected: " + resultSetRewindable3.size() + " -----------------------------");
                        resultSetRewindable3.reset();
                        resultSetTextFormatter2.dump(printWriter, false);
                        resultSetRewindable3.reset();
                        if (printModelsOnFailure) {
                            printWriter.println("---------------------------------------");
                            resultSetFormatter2.toModel().write((Writer)printWriter, "N3");
                            resultSetRewindable3.reset();
                        }
                        printWriter.println();
                        printWriter.flush();
                        resultSetTextFormatter.close();
                        resultSetTextFormatter2.close();
                        resultSetFormatter.close();
                        resultSetFormatter2.close();
                        resultSetRewindable2.close();
                        resultSetRewindable3.close();
                        QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                    }
                }
                catch (Exception exception) {
                    log.warn((Object)"Exception in result testing", (Throwable)exception);
                    QueryTest.fail((String)("Exception in result testing: " + exception));
                }
            }
            resultSetRewindable.close();
        }

        public static boolean resultSetEquivalent(ResultSet resultSet, ResultSet resultSet2, PrefixMapping prefixMapping) {
            ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSet, prefixMapping);
            Model model = resultSetFormatter.toModel();
            long l = model.size();
            ResultSetFormatter resultSetFormatter2 = new ResultSetFormatter(resultSet2, prefixMapping);
            Model model2 = resultSetFormatter2.toModel();
            long l2 = model.size();
            return model.isIsomorphicWith(model2);
        }

        void runTestConstruct(Query query2, QueryExecution queryExecution) throws Exception {
            System.err.println("Not implmented: runTestConstruct");
        }

        void runTestDescribe(Query query2, QueryExecution queryExecution) throws Exception {
            System.err.println("Not implmented: runTestDescribe");
        }

        void runTestAsk(Query query2, QueryExecution queryExecution) throws Exception {
            System.err.println("Not implmented: runTestDescribe");
        }

        public String toString() {
            if (this.testItem.getName() != null) {
                return this.testItem.getName();
            }
            return super.getName();
        }

        String makeDescription() {
            Object object;
            String string = "";
            if (this.testItem.getDataFiles() != null) {
                object = this.testItem.getDataFiles().iterator();
                while (object.hasNext()) {
                    this.description = string + (String)object.next();
                }
            }
            object = "Test " + this.testNumber + " :: QueryFile=" + this.testItem.getQueryFile() + ", DataFile=" + string + ", ResultsFile=" + this.testItem.getResultFile();
            return object;
        }
    }
}

