/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.ResultSetProcessor;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;

public class PlainFormat
implements ResultSetProcessor {
    PrintWriter out;
    int count = 0;
    boolean lineNumbers = true;
    boolean first = true;
    ResultSet resultSet;
    PrefixMapping prefixMapping;

    public PlainFormat(OutputStream outputStream, ResultSet resultSet, PrefixMapping prefixMapping) {
        this.out = FileUtils.asPrintWriterUTF8((OutputStream)outputStream);
        this.resultSet = resultSet;
        this.prefixMapping = prefixMapping;
    }

    public void start(ResultSet resultSet) {
    }

    public void finish(ResultSet resultSet) {
        this.out.flush();
    }

    public void start(QuerySolution querySolution) {
        ++this.count;
        this.insertLineNumber();
        this.first = true;
    }

    public void finish(QuerySolution querySolution) {
        this.out.println();
    }

    public void binding(String string, RDFNode rDFNode) {
        if (rDFNode == null) {
            return;
        }
        if (!this.first) {
            this.out.print(" ");
        }
        String string2 = QueryPrintUtils.stringForRDFNode(rDFNode, this.prefixMapping);
        this.out.print("( ?" + string + " = " + string2 + ")");
        this.first = false;
    }

    void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String string = Integer.toString(this.count);
        for (int i = 0; i < 3 - string.length(); ++i) {
            this.out.print(' ');
        }
        this.out.print(string);
        this.out.print(' ');
    }
}

