/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.parser.rdql.BRQLParser1;
import com.hp.hpl.jena.query.parser.rdql.EvalTypeException;
import com.hp.hpl.jena.query.parser.rdql.Expr;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.ExprNumeric;
import com.hp.hpl.jena.query.parser.rdql.NodeValue;
import com.hp.hpl.jena.query.parser.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.query.parser.rdql.WorkingVar;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;

public class Q_UnaryMinus
extends ExprNode
implements ExprNumeric {
    Expr expr;
    private String printName = "unaryminus";
    private String opSymbol = "-";

    Q_UnaryMinus(int n) {
        super(n);
    }

    Q_UnaryMinus(BRQLParser1 bRQLParser1, int n) {
        super(bRQLParser1, n);
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.expr.eval(query2, indexValues);
        if (!nodeValue.isNumber()) {
            throw new EvalTypeException("Q_UnaryMinus: Wanted a number: got " + this.expr);
        }
        WorkingVar workingVar = new WorkingVar();
        if (nodeValue.isInt()) {
            workingVar.setInt(-nodeValue.getInt());
        } else {
            workingVar.setDouble(-nodeValue.getDouble());
        }
        return workingVar;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryMinus: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.expr instanceof Expression) {
            return (Expression)this.expr;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        RDQLQueryPrintUtils.format(indentedLineBuffer, this.expr, null, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

