/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.parser.rdql.BRQLParser1;
import com.hp.hpl.jena.query.parser.rdql.Expr;
import com.hp.hpl.jena.query.parser.rdql.ExprBoolean;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.NodeValue;
import com.hp.hpl.jena.query.parser.rdql.NodeValueSettable;
import com.hp.hpl.jena.query.parser.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.query.parser.rdql.WorkingVar;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;

public class Q_StringEqual
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    protected static boolean enableRDFLiteralSameValueAs = true;
    protected static String printName = "str=";
    protected static String opSymbol = "eq";

    Q_StringEqual(int n) {
        super(n);
    }

    Q_StringEqual(BRQLParser1 bRQLParser1, int n) {
        super(bRQLParser1, n);
    }

    protected boolean rawEval(NodeValue nodeValue, NodeValue nodeValue2) {
        if (enableRDFLiteralSameValueAs && nodeValue.isNode() && nodeValue.getNode().isLiteral() && nodeValue2.isNode() && nodeValue2.getNode().isLiteral()) {
            Node node = nodeValue.getNode();
            Node node2 = nodeValue2.getNode();
            return node.sameValueAs((Object)node2);
        }
        String string = nodeValue.valueString();
        String string2 = nodeValue2.valueString();
        return string.equals(string2);
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query2, indexValues);
        NodeValue nodeValue2 = this.right.eval(query2, indexValues);
        boolean bl = this.rawEval(nodeValue, nodeValue2);
        NodeValueSettable nodeValueSettable = nodeValue instanceof NodeValueSettable ? (NodeValueSettable)nodeValue : (nodeValue2 instanceof NodeValueSettable ? (NodeValueSettable)nodeValue2 : new WorkingVar());
        nodeValueSettable.setBoolean(bl);
        return nodeValueSettable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return this.getClass().getName();
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return (Expression)this.left;
        }
        if (n == 1 && this.right instanceof Expression) {
            return (Expression)this.right;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, printName, opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, printName, opSymbol);
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        RDQLQueryPrintUtils.format(indentedLineBuffer, this.left, this.right, printName, opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

