/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.parser.rdql.BRQLParser1;
import com.hp.hpl.jena.query.parser.rdql.EvalTypeException;
import com.hp.hpl.jena.query.parser.rdql.Expr;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.ExprNumeric;
import com.hp.hpl.jena.query.parser.rdql.NodeValue;
import com.hp.hpl.jena.query.parser.rdql.NodeValueSettable;
import com.hp.hpl.jena.query.parser.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.query.parser.rdql.WorkingVar;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;

public class Q_RightUnsignedShift
extends ExprNode
implements Expr,
ExprNumeric {
    Expr left;
    Expr right;
    private String printName = "rshiftz";
    private String opSymbol = ">>>";

    Q_RightUnsignedShift(int n) {
        super(n);
    }

    Q_RightUnsignedShift(BRQLParser1 bRQLParser1, int n) {
        super(bRQLParser1, n);
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query2, indexValues);
        NodeValue nodeValue2 = this.right.eval(query2, indexValues);
        if (!nodeValue.isNumber()) {
            throw new EvalTypeException("Q_RightUnsignedShift: Wanted a number: " + nodeValue);
        }
        if (!nodeValue2.isNumber()) {
            throw new EvalTypeException("Q_RightUnsignedShift: Wanted a number: " + nodeValue2);
        }
        NodeValueSettable nodeValueSettable = nodeValue instanceof NodeValueSettable ? (NodeValueSettable)nodeValue : (nodeValue2 instanceof NodeValueSettable ? (NodeValueSettable)nodeValue2 : new WorkingVar());
        if (!nodeValue.isInt() || !nodeValue2.isInt()) {
            throw new EvalTypeException("Q_RightUnsignedShift: one or both operands are doubles: " + nodeValue + " >>> " + nodeValue2);
        }
        nodeValueSettable.setInt(nodeValue.getInt() >>> (int)nodeValue2.getInt());
        return nodeValueSettable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_RightUnsignedShift: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return (Expression)this.left;
        }
        if (n == 1 && this.right instanceof Expression) {
            return (Expression)this.right;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        RDQLQueryPrintUtils.format(indentedLineBuffer, this.left, this.right, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

