/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ValueException;
import com.hp.hpl.jena.query.parser.rdql.BRQLParser1;
import com.hp.hpl.jena.query.parser.rdql.EvalFailureException;
import com.hp.hpl.jena.query.parser.rdql.Expr;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.NodeValue;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;

public class ParsedLiteral
extends ExprNode
implements Expr,
NodeValue {
    static Model model = ModelFactory.createDefaultModel();
    protected boolean isSet = false;
    private boolean isInt = false;
    private boolean isBoolean = false;
    private boolean isDouble = false;
    private boolean isURI = false;
    private boolean isString = false;
    private boolean isGraphNode = false;
    private long valInt;
    private boolean valBoolean;
    private double valDouble;
    private String valString;
    private String valURI;
    private Node valGraphNode;

    ParsedLiteral(int n) {
        super(n);
    }

    ParsedLiteral(BRQLParser1 bRQLParser1, int n) {
        super(bRQLParser1, n);
    }

    public ParsedLiteral() {
        super(-1);
        this.unset();
    }

    protected ParsedLiteral(NodeValue nodeValue) {
        super(-1);
        if (nodeValue.isBoolean()) {
            this._setBoolean(nodeValue.getBoolean());
            return;
        }
        if (nodeValue.isInt()) {
            this._setInt(nodeValue.getInt());
            return;
        }
        if (nodeValue.isDouble()) {
            this._setDouble(nodeValue.getDouble());
            return;
        }
        if (nodeValue.isURI()) {
            this._setURI(nodeValue.getURI());
            return;
        }
        if (nodeValue.isNode()) {
            this._setNode(nodeValue.getNode());
            return;
        }
        if (nodeValue.isString()) {
            this._setString(nodeValue.getString());
            return;
        }
    }

    protected void unset() {
        this.isSet = false;
        this.valString = null;
        this.valGraphNode = null;
        this.valInt = 0L;
        this.valBoolean = false;
        this.valDouble = 0.0;
        this.valURI = null;
        this.valGraphNode = null;
        this.isInt = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isURI = false;
        this.isString = false;
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        if (!this.isSet) {
            throw new EvalFailureException("Literal value not set");
        }
        return this;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isNumber() {
        this.forceNumber();
        return this.isSet && (this.isInt || this.isDouble);
    }

    public boolean isInt() {
        this.forceInt();
        return this.isSet && this.isInt;
    }

    public boolean isDouble() {
        this.forceDouble();
        return this.isSet && this.isDouble;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    public boolean isNode() {
        return this.isSet && this.isGraphNode;
    }

    protected void _setInt(long l) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = l;
    }

    protected void _setDouble(double d) {
        this.unset();
        this.isSet = true;
        this.isDouble = true;
        this.valDouble = d;
    }

    protected void _setBoolean(boolean bl) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
    }

    protected void _setString(String string) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = string;
    }

    protected void _setURI(String string) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.isString = true;
        this.valURI = string;
        this.valString = string;
    }

    protected void _setNode(Node node) {
        this.unset();
        this.isSet = true;
        this.isGraphNode = true;
        this.valGraphNode = node;
        this.isString = false;
        this.valString = null;
        if (node.isLiteral()) {
            this.valString = node.getLiteral().getLexicalForm();
        }
        if (node.isURI()) {
            this.valString = node.getURI();
            this.valURI = node.getURI();
            this.isURI = true;
        }
        if (node.isBlank()) {
            this.valString = node.getBlankNodeId().toString();
        }
        if (this.valString != null) {
            this.isString = true;
        }
    }

    private void forceInt() {
        if (!this.isSet || this.isInt || !this.isString) {
            return;
        }
        try {
            this.valInt = Long.parseLong(this.valString);
            this.isInt = true;
            this.isDouble = true;
            this.valDouble = this.valInt;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void forceDouble() {
        if (!this.isSet || this.isDouble || !this.isString) {
            return;
        }
        try {
            this.valDouble = Double.parseDouble(this.valString);
            this.isDouble = true;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void forceNumber() {
        if (!this.isSet || this.isInt || this.isDouble || !this.isString) {
            return;
        }
        this.forceInt();
        if (!this.isInt) {
            this.forceDouble();
        }
    }

    public long getInt() {
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public double getDouble() {
        if (!this.isSet || !this.isDouble && !this.isInt) {
            throw new ValueException("Not a double: " + this);
        }
        if (this.isInt) {
            return this.valInt;
        }
        return this.valDouble;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new ValueException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            throw new ValueException("Not a string: " + this);
        }
        return this.valString;
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new ValueException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public Node getNode() {
        if (!this.isSet) {
            throw new ValueException("Not a graph node: " + this);
        }
        return this.valGraphNode;
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.getNode();
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isGraphNode) {
            if (this.valGraphNode.isLiteral()) {
                String string;
                StringBuffer stringBuffer = new StringBuffer();
                LiteralLabel literalLabel = this.valGraphNode.getLiteral();
                stringBuffer.append('\"');
                stringBuffer.append(literalLabel.getLexicalForm());
                stringBuffer.append('\"');
                String string2 = literalLabel.getDatatypeURI();
                if (string2 != null) {
                    stringBuffer.append("^^");
                    stringBuffer.append(string2);
                }
                if ((string = literalLabel.language()) != null) {
                    stringBuffer.append("@");
                    stringBuffer.append(string);
                }
            }
            if (this.valGraphNode.isURI()) {
                this.valString = "<" + this.valGraphNode.getURI() + ">";
            }
            if (this.valGraphNode.isBlank()) {
                this.valString = this.valGraphNode.getBlankNodeId().toString();
            }
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "literal:unknown";
    }

    public String asUnquotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isString) {
            return this.valString;
        }
        if (this.isGraphNode) {
            return this.valGraphNode.toString();
        }
        return "literal:unknown";
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asPrefixString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return "int:" + Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return "double:" + Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        if (this.isGraphNode) {
            return "node:" + this.valGraphNode;
        }
        return "literal:unknown";
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        indentedLineBuffer.append(this.asPrefixString());
    }

    public String valueString() {
        return this.asUnquotedString();
    }

    public String toString() {
        return this.asUnquotedString();
    }
}

