/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.arq;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.parser.QNameExeception;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import com.hp.hpl.jena.query.parser.arq.ARQParserConstants;
import com.hp.hpl.jena.query.parser.arq.ParseException;
import com.hp.hpl.jena.query.parser.arq.Token;
import com.hp.hpl.jena.query.util.JenaURIException;
import com.hp.hpl.jena.query.util.RelURI;

class ARQParserBase
implements ARQParserConstants {
    Query query;

    ARQParserBase() {
    }

    protected void setQuery(Query query2) {
        this.query = query2;
    }

    public Query getQuery() {
        return this.query;
    }

    protected String fixupURI(String string) throws ParseException {
        if (this.query == null) {
            return string;
        }
        if (this.query.getBaseURI() != null) {
            try {
                string = RelURI.resolve(string, this.query.getBaseURI());
            }
            catch (JenaURIException jenaURIException) {
                throw new ParseException(jenaURIException.getMessage());
            }
        }
        return string;
    }

    protected String fixupQName(Token token) {
        String string = token.image;
        String string2 = this.query.expandQName(string);
        if (string2 == null) {
            String string3 = "Line " + token.beginLine + ", column " + token.beginColumn;
            throw new QNameExeception(string3 + ": Unresolved qname: " + string);
        }
        return string2;
    }

    protected String stripQuotes(String string) {
        return string.substring(1, string.length() - 1);
    }

    protected String unescape(String string) {
        return ARQParserBase.unescape(string, '\\');
    }

    protected String regexPattern(ARQParser aRQParser) {
        int n = 0;
        Token token = null;
        do {
            token = aRQParser.getNextToken();
            if (token.kind != 0) continue;
            throw new Error("End of file: expecting the start of a regular expression");
        } while ((n = token.image.charAt(0)) == 32 || n == 10 || n == 9 || n == 13 || n == 12);
        if (n != 47) {
            if (n == 109) {
                token = aRQParser.getNextToken();
                n = token.image.charAt(0);
            } else if (n == 34 || n == 39) {
                throw new Error("Invalid regular expression (starts with [" + (char)n + "]) at line " + token.beginLine + " column " + token.beginColumn + ".");
            }
            if (Character.isLetterOrDigit((char)n)) {
                throw new Error("Invalid start to regular expression at line " + token.beginLine + " column " + token.beginColumn + ".");
            }
        }
        String string = "";
        boolean bl = false;
        while (true) {
            token = aRQParser.getNextToken();
            if (token.kind == 0) {
                throw new Error("End of file during regular expression");
            }
            int n2 = token.image.charAt(0);
            if (n2 == 10 || n2 == 13 || n2 == 12) {
                throw new Error("Invalid regular expression at line " + token.beginLine + " column " + token.beginColumn + ".");
            }
            if (bl) {
                if (n2 == 110) {
                    n2 = 10;
                }
                if (n2 == 116) {
                    n2 = 9;
                }
                if (n2 == 114) {
                    n2 = 13;
                }
                if (n2 == 98) {
                    n2 = 8;
                }
                if (n2 != n) {
                    string = string + '\\';
                }
                bl = false;
            } else {
                if (n2 == 92) {
                    bl = true;
                    continue;
                }
                if (n2 == n) break;
            }
            string = string + (char)n2;
        }
        return string;
    }

    protected String regexModifiers(ARQParser aRQParser) {
        String string;
        block1: {
            string = "";
            while (true) {
                Token token = aRQParser.getNextToken();
                if (token.kind == 0) break block1;
                char c = token.image.charAt(0);
                if (c != 'i' && c != 'm' && c != 's' && c != 'x') break;
                string = string + c;
            }
            aRQParser.jj_input_stream.backup(1);
        }
        return string;
    }

    static String unescape(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c || i >= string.length() - 1) continue;
            char c2 = string.charAt(i + 1);
            if (c2 == 'n') {
                c2 = '\n';
            }
            if (c2 == 't') {
                c2 = '\t';
            }
            if (c2 == 'r') {
                c2 = '\r';
            }
            if (c2 == 'b') {
                c2 = '\b';
            }
            string = string.substring(0, i) + c2 + string.substring(i + 2);
        }
        return string;
    }
}

