/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import org.apache.commons.logging.LogFactory;

public class NodeVar
extends ExprNode {
    String name;
    int index;

    public NodeVar(String string) {
        this.name = string;
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        this.index = variableIndexes.indexOf(this.name);
        return this;
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        Node node = (Node)indexValues.get(this.index);
        if (node == null) {
            LogFactory.getLog((Class)NodeVar.class).warn((Object)("Unbound variable: " + this.name));
            return NodeValue.makeString("unset: " + this.name + "/" + this.index);
        }
        return NodeValue.makeNode(node);
    }

    public void check() {
    }

    public String asInfixString() {
        return this.toString();
    }

    public String asPrefixString() {
        return this.toString();
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        indentedLineBuffer.append(this.toString());
    }

    public String toString() {
        return "?" + this.name;
    }
}

