/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ValueException;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.vocabulary.XSD;
import org.apache.commons.logging.LogFactory;

public class NodeValue
extends ExprNode {
    static Model model = ModelFactory.createDefaultModel();
    protected boolean isSet = false;
    private boolean isInt = false;
    private boolean isBoolean = false;
    private boolean isDouble = false;
    private boolean isURI = false;
    private boolean isString = false;
    private boolean isGraphNode = false;
    private long valInt;
    private boolean valBoolean;
    private double valDouble;
    private String valString;
    private String valURI;
    private Node valGraphNode;

    NodeValue() {
    }

    public static NodeValue makeInt(long l) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setInt(l);
        return nodeValue;
    }

    public static NodeValue makeInt(String string) {
        NodeValue nodeValue = NodeValue.makeString(string);
        nodeValue.forceInt(true);
        return nodeValue;
    }

    public static NodeValue makeDouble(double d) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setDouble(d);
        return nodeValue;
    }

    public static NodeValue makeDouble(String string) {
        NodeValue nodeValue = NodeValue.makeString(string);
        nodeValue.forceDouble(true);
        return nodeValue;
    }

    public static NodeValue makeBoolean(boolean bl) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setBoolean(bl);
        return nodeValue;
    }

    public static NodeValue makeString(String string) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setString(string);
        return nodeValue;
    }

    public static NodeValue makeURI(String string) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setURI(string);
        return nodeValue;
    }

    public static NodeValue makeNode(Node node) {
        NodeValue nodeValue = new NodeValue();
        nodeValue._setNode(node);
        return nodeValue;
    }

    public static NodeValue makeNode(String string, String string2, Node node) {
        String string3 = node == null ? null : node.getURI();
        return NodeValue.makeNode(string, string2, string3);
    }

    public static NodeValue makeNode(String string, String string2, String string3) {
        NodeValue nodeValue = new NodeValue();
        if (string3 != null && string3.equals("")) {
            string3 = null;
        }
        Node node = null;
        if (string3 != null) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
            node = Node.createLiteral((String)string, null, (RDFDatatype)rDFDatatype);
        } else {
            node = Node.createLiteral((String)string, (String)string2, null);
        }
        return NodeValue.makeNode(node);
    }

    public static NodeValue makeNodeInt(String string) {
        NodeValue nodeValue = NodeValue.makeNode(string, null, XSD.integer.getURI());
        nodeValue.forceInt(true);
        return nodeValue;
    }

    public static NodeValue makeNodeDouble(String string) {
        NodeValue nodeValue = NodeValue.makeNode(string, null, XSD.xdouble.getURI());
        nodeValue.forceDouble(true);
        return nodeValue;
    }

    protected NodeValue(NodeValue nodeValue) {
        if (nodeValue.isBoolean()) {
            this._setBoolean(nodeValue.getBoolean());
            return;
        }
        if (nodeValue.isInt()) {
            this._setInt(nodeValue.getInt());
            return;
        }
        if (nodeValue.isDouble()) {
            this._setDouble(nodeValue.getDouble());
            return;
        }
        if (nodeValue.isURI()) {
            this._setURI(nodeValue.getURI());
            return;
        }
        if (nodeValue.isNode()) {
            this._setNode(nodeValue.getNode());
            return;
        }
        if (nodeValue.isString()) {
            this._setString(nodeValue.getString());
            return;
        }
        LogFactory.getLog((Class)NodeValue.class).warn((Object)("Unknown NodeValue in constructor: " + nodeValue));
    }

    protected void unset() {
        this.isSet = false;
        this.valString = null;
        this.valGraphNode = null;
        this.valInt = 0L;
        this.valBoolean = false;
        this.valDouble = 0.0;
        this.valURI = null;
        this.valGraphNode = null;
        this.isInt = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isURI = false;
        this.isString = false;
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        if (!this.isSet) {
            throw new ValueException("Literal value not set");
        }
        return this;
    }

    public void check() {
        if (!this.isSet()) {
            throw new ValueException("Unset NodeValue");
        }
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isNumber() {
        this.forceNumber();
        return this.isSet && (this.isInt || this.isDouble);
    }

    public boolean isInt() {
        this.forceInt(false);
        return this.isSet && this.isInt;
    }

    public boolean isDouble() {
        this.forceDouble(false);
        return this.isSet && this.isDouble;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    public boolean isNode() {
        return this.isSet && this.isGraphNode;
    }

    protected void _setInt(long l) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = l;
    }

    protected void _setDouble(double d) {
        this.unset();
        this.isSet = true;
        this.isDouble = true;
        this.valDouble = d;
    }

    protected void _setBoolean(boolean bl) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
    }

    protected void _setString(String string) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = string;
    }

    protected void _setURI(String string) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.isString = true;
        this.valURI = string;
        this.valString = string;
    }

    protected void _setNode(Node node) {
        this.unset();
        this.isSet = true;
        this.isGraphNode = true;
        this.valGraphNode = node;
        this.isString = false;
        this.valString = null;
        if (node.isLiteral()) {
            this.valString = node.getLiteral().getLexicalForm();
        }
        if (node.isURI()) {
            this.valString = node.getURI();
            this.valURI = node.getURI();
            this.isURI = true;
        }
        if (node.isBlank()) {
            this.valString = node.getBlankNodeId().toString();
        }
        if (this.valString != null) {
            this.isString = true;
        }
    }

    private void forceInt(boolean bl) {
        if (!this.isSet || this.isInt || !this.isString) {
            return;
        }
        try {
            this.valInt = Long.parseLong(this.valString);
            this.isInt = true;
            this.isDouble = true;
            this.valDouble = this.valInt;
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                throw numberFormatException;
            }
            return;
        }
    }

    private void forceDouble(boolean bl) {
        if (!this.isSet || this.isDouble || !this.isString) {
            return;
        }
        try {
            this.valDouble = Double.parseDouble(this.valString);
            this.isDouble = true;
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                throw numberFormatException;
            }
            return;
        }
    }

    private void forceNumber() {
        if (!this.isSet || this.isInt || this.isDouble || !this.isString) {
            return;
        }
        this.forceInt(false);
        if (!this.isInt) {
            this.forceDouble(false);
        }
    }

    public long getInt() {
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public double getDouble() {
        if (!this.isSet || !this.isDouble && !this.isInt) {
            throw new ValueException("Not a double: " + this);
        }
        if (this.isInt) {
            return this.valInt;
        }
        return this.valDouble;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new ValueException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            throw new ValueException("Not a string: " + this);
        }
        return this.valString;
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new ValueException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public Node getNode() {
        if (!this.isSet) {
            throw new ValueException("Not a graph node: " + this);
        }
        return this.valGraphNode;
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.getNode();
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isGraphNode) {
            if (this.valGraphNode.isLiteral()) {
                String string;
                StringBuffer stringBuffer = new StringBuffer();
                LiteralLabel literalLabel = this.valGraphNode.getLiteral();
                stringBuffer.append('\"');
                stringBuffer.append(literalLabel.getLexicalForm());
                stringBuffer.append('\"');
                String string2 = literalLabel.getDatatypeURI();
                if (string2 != null) {
                    stringBuffer.append("^^");
                    stringBuffer.append(string2);
                }
                if ((string = literalLabel.language()) != null) {
                    stringBuffer.append("@");
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            if (this.valGraphNode.isURI()) {
                return "<" + this.valGraphNode.getURI() + ">";
            }
            if (this.valGraphNode.isBlank()) {
                return this.valGraphNode.getBlankNodeId().toString();
            }
            if (this.valGraphNode.isVariable()) {
                return "?" + this.valGraphNode.getName();
            }
            return "node:unknown";
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "literal:unknown";
    }

    public String asUnquotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isString) {
            return this.valString;
        }
        if (this.isGraphNode) {
            return this.valGraphNode.toString();
        }
        return "literal:unknown";
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asPrefixString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInt) {
            return "int:" + Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return "double:" + Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        if (this.isGraphNode) {
            return "node:" + this.valGraphNode;
        }
        return "literal:unknown";
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        indentedLineBuffer.append(this.asPrefixString());
    }

    public String valueString() {
        return this.asUnquotedString();
    }

    public String toString() {
        return this.asUnquotedString();
    }
}

