/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprPrintUtils;
import com.hp.hpl.jena.query.expr.NodePatternLiteral;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class ExprNodeStringMatch
extends ExprNode {
    ExprNode left = null;
    NodePatternLiteral regex = null;
    String opSymbol;
    String opName;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();
    Pattern pattern = null;

    protected ExprNodeStringMatch(ExprNode exprNode, NodePatternLiteral nodePatternLiteral, String string, String string2) {
        this.left = exprNode;
        this.regex = nodePatternLiteral;
        this.opSymbol = string;
        this.opName = string2;
        try {
            this.pattern = this.compiler.compile(this.regex.getPattern(), this.regex.getMask());
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new ExprEvalException("ExprNodeStringMatch: Pattern exception: " + (Object)((Object)malformedPatternException));
        }
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        if (this.left != null) {
            this.left.prepare(variableIndexes);
        }
        return this;
    }

    protected boolean match(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query2, indexValues);
        String string = nodeValue.getString();
        return this.matcher.contains(string, this.pattern);
    }

    public Object evalObject(IndexValues indexValues) {
        return this.evalNode(null, indexValues);
    }

    public boolean evalBool(IndexValues indexValues) {
        return this.evalBool(null, indexValues);
    }

    protected boolean evalBool(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.evalNode(query2, indexValues);
        return nodeValue == null ? false : nodeValue.getBoolean();
    }

    public NodeValue evalNode(Query query2, IndexValues indexValues) {
        try {
            return this.eval(query2, indexValues);
        }
        catch (ExprException exprException) {
            return null;
        }
        catch (Exception exception) {
            log.warn((Object)"ARQ : general exception!", (Throwable)exception);
            return null;
        }
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public abstract String getFun();

    public boolean isApply() {
        return true;
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return this.left;
        }
        if (n == 1 && this.regex instanceof Expression) {
            return (Expression)this.regex;
        }
        return null;
    }

    protected String constructURI(String string) {
        if (string.lastIndexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        return "urn:x-jena:expr:" + string;
    }

    public abstract void checkSelf();

    public void check() {
        this.checkSelf();
        this.left.check();
        this.regex.check();
    }

    public String asInfixString() {
        return ExprPrintUtils.asInfixString(this.left, this.regex, this.opName, this.opSymbol);
    }

    public String asPrefixString() {
        return ExprPrintUtils.asPrefixString(this.left, this.regex, this.opName, this.opSymbol);
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        ExprPrintUtils.format(indentedLineBuffer, this.left, this.regex, this.opName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

