/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNodeN;
import com.hp.hpl.jena.query.expr.ExprPrintUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;

public abstract class ExprNode2
extends ExprNodeN {
    ExprNode left = null;
    ExprNode right = null;
    String opSymbol;
    String opName;

    protected ExprNode2(ExprNode exprNode, ExprNode exprNode2, String string, String string2) {
        this.left = exprNode;
        this.right = exprNode2;
        this.opSymbol = string;
        this.opName = string2;
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        if (this.left != null) {
            this.left.prepare(variableIndexes);
        }
        if (this.right != null) {
            this.right.prepare(variableIndexes);
        }
        return this;
    }

    public abstract String getFun();

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.left instanceof Expression) {
            return this.left;
        }
        if (n == 1 && this.right instanceof Expression) {
            return this.right;
        }
        return null;
    }

    public abstract void checkSelf();

    public void check() {
        this.checkSelf();
        this.left.check();
        this.right.check();
    }

    public String asInfixString() {
        return ExprPrintUtils.asInfixString(this.left, this.right, this.opName, this.opSymbol);
    }

    public String asPrefixString() {
        return ExprPrintUtils.asPrefixString(this.left, this.right, this.opName, this.opSymbol);
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        ExprPrintUtils.format(indentedLineBuffer, this.left, this.right, this.opName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

