/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNodeN;
import com.hp.hpl.jena.query.expr.ExprPrintUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;

public abstract class ExprNode1
extends ExprNodeN {
    ExprNode expr = null;
    String opSymbol;
    String opName;

    protected ExprNode1(ExprNode exprNode, String string, String string2) {
        this.expr = exprNode;
        this.opSymbol = string;
        this.opName = string2;
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        if (this.expr != null) {
            this.expr.prepare(variableIndexes);
        }
        return this;
    }

    public abstract String getFun();

    public int argCount() {
        return 1;
    }

    public Expression getArg(int n) {
        if (n == 0 && this.expr instanceof Expression) {
            return this.expr;
        }
        return null;
    }

    public abstract void checkSelf();

    public void check() {
        this.checkSelf();
        this.expr.check();
    }

    public String asInfixString() {
        return ExprPrintUtils.asInfixString(this.expr, this.opName, this.opSymbol);
    }

    public String asPrefixString() {
        return ExprPrintUtils.asPrefixString(this.expr, this.opName, this.opSymbol);
    }

    public void format(IndentedLineBuffer indentedLineBuffer) {
        ExprPrintUtils.format(indentedLineBuffer, this.expr, this.opName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

