/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingIndex;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.expr.NodeValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ExprNode
implements Expression,
Valuator,
Constraint,
Expr {
    static Log log = LogFactory.getLog((Class)ExprNode.class);
    static final String exprBaseURI = "urn:x-jena:expr:";

    public boolean isSatisfied(Binding binding) {
        BindingIndex bindingIndex;
        BindingIndex bindingIndex2 = bindingIndex = new BindingIndex(binding);
        this.prepare(bindingIndex2);
        BindingIndex bindingIndex3 = bindingIndex;
        return this.isSatisfied(bindingIndex3);
    }

    public boolean isSatisfied(IndexValues indexValues) {
        return this.evalBool(indexValues);
    }

    public Object evalObject(IndexValues indexValues) {
        return this.evalNode(null, indexValues);
    }

    public boolean evalBool(IndexValues indexValues) {
        return this.evalBool(null, indexValues);
    }

    protected boolean evalBool(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.evalNode(query2, indexValues);
        return nodeValue == null ? false : nodeValue.getBoolean();
    }

    public NodeValue evalNode(Query query2, IndexValues indexValues) {
        try {
            return this.eval(query2, indexValues);
        }
        catch (ExprException exprException) {
            return null;
        }
        catch (Exception exception) {
            log.warn((Object)"ARQ : general exception!", (Throwable)exception);
            return null;
        }
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public boolean isApply() {
        return false;
    }

    public String getFun() {
        return null;
    }

    public int argCount() {
        return 0;
    }

    public Expression getArg(int n) {
        return null;
    }

    protected String constructURI(String string) {
        if (string.lastIndexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        return exprBaseURI + string;
    }

    public String toString() {
        return this.asInfixString();
    }
}

