/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ExprBoolean;
import com.hp.hpl.jena.query.expr.ExprCheckException;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.ExprNumeric;
import com.hp.hpl.jena.query.expr.NodeValue;

public class E_LogicalOr
extends ExprNode2
implements ExprBoolean {
    private static final String printName = "or";
    private static final String symbol = "||";

    public E_LogicalOr(ExprNode exprNode, ExprNode exprNode2) {
        super(exprNode, exprNode2, symbol, printName);
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query2, indexValues);
        NodeValue nodeValue2 = this.right.eval(query2, indexValues);
        if (!nodeValue.isBoolean()) {
            throw new ExprEvalException("E_LogicalOr: Wanted a boolean: " + nodeValue);
        }
        if (!nodeValue2.isBoolean()) {
            throw new ExprEvalException("E_LogicalOr: Wanted a boolean: " + nodeValue2);
        }
        return NodeValue.makeBoolean(nodeValue.getBoolean() || nodeValue2.getBoolean());
    }

    public void checkSelf() {
        if (this.left instanceof ExprNumeric) {
            throw new ExprCheckException("E_LogicalOr(left)");
        }
        if (this.right instanceof ExprNumeric) {
            throw new ExprCheckException("E_LogicalOr(right)");
        }
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }
}

