/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ExprBoolean;
import com.hp.hpl.jena.query.expr.ExprCheckException;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.NodeValue;

public class E_LessThanOrEqual
extends ExprNode2
implements ExprBoolean {
    private static final String printName = "le";
    private static final String symbol = "<=";

    public E_LessThanOrEqual(ExprNode exprNode, ExprNode exprNode2) {
        super(exprNode, exprNode2, symbol, printName);
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        NodeValue nodeValue = this.left.eval(query2, indexValues);
        NodeValue nodeValue2 = this.right.eval(query2, indexValues);
        if (!nodeValue.isNumber()) {
            throw new ExprEvalException("E_LessThanOrEqual: Wanted a number: " + nodeValue);
        }
        if (!nodeValue2.isNumber()) {
            throw new ExprEvalException("E_LessThanOrEqual: Wanted a number: " + nodeValue2);
        }
        if (nodeValue.isInt() && nodeValue2.isInt()) {
            return NodeValue.makeBoolean(nodeValue.getInt() <= nodeValue2.getInt());
        }
        return NodeValue.makeBoolean(nodeValue.getDouble() <= nodeValue2.getDouble());
    }

    public void checkSelf() {
        if (this.left instanceof ExprBoolean) {
            throw new ExprCheckException("E_LessThanOrEqual(left)");
        }
        if (this.right instanceof ExprBoolean) {
            throw new ExprCheckException("E_LessThanOrEqual(right)");
        }
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }
}

