/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Binding1;
import com.hp.hpl.jena.query.core.DataSourceNamedGroup;
import com.hp.hpl.jena.query.core.ElementSource;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import java.util.Iterator;

public class SourceIterator
extends QueryIterator {
    boolean finished = false;
    Binding inputBinding;
    Binding binding = null;
    DataSourceNamedGroup data;
    ElementSource sourceElement;
    ClosableIterator current = null;
    Iterator dataSourceURIs = null;

    SourceIterator(Mark mark, Binding binding, DataSourceNamedGroup dataSourceNamedGroup, ElementSource elementSource) {
        super(mark);
        this.inputBinding = binding;
        this.data = dataSourceNamedGroup;
        this.sourceElement = elementSource;
        this.dataSourceURIs = SourceIterator.makeSources(this.data, binding, this.sourceElement.sourceNode);
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (!this.finished && this.current == null) {
            this.current = this.makeIterator();
        }
        if (this.current == null) {
            this.close();
            return false;
        }
        while (!this.current.hasNext()) {
            this.current = this.makeIterator();
            if (this.current != null) continue;
            this.close();
            return false;
        }
        return true;
    }

    public Object next() {
        return this.current.next();
    }

    public void close() {
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.current.close();
        }
        this.current = null;
        this.binding = null;
        this.data = null;
        this.finished = true;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    private ClosableIterator makeIterator() {
        if (this.dataSourceURIs == null) {
            return null;
        }
        if (!this.dataSourceURIs.hasNext()) {
            return null;
        }
        String string = (String)this.dataSourceURIs.next();
        DataSource dataSource = this.data.getDataSource(string);
        if (dataSource == null) {
            return null;
        }
        Binding binding = this.inputBinding;
        if (this.sourceElement.sourceNode != null && this.sourceElement.sourceNode.isVariable()) {
            binding = new Binding1(this.sourceElement.sourceNode.getName(), Node.createURI((String)string), this.inputBinding);
        }
        return this.sourceElement.element.exec(this.mark, (ClosableIterator)new SingletonIterator((Object)binding), dataSource);
    }

    private static Iterator makeSources(DataSourceNamedGroup dataSourceNamedGroup, Binding binding, Node node) {
        Node node2 = SourceIterator.resolve(binding, node);
        if (node2 != null && !node2.isURI()) {
            throw new QueryException("SOURCE is not a URI: " + node2);
        }
        if (node2 == null) {
            return dataSourceNamedGroup.listModelLabels();
        }
        return new SingletonIterator((Object)node2.getURI());
    }

    private static Node resolve(Binding binding, Node node) {
        if (node == null) {
            return node;
        }
        if (!node.isVariable()) {
            return node;
        }
        if (binding == null) {
            return null;
        }
        return (Node)binding.get(node.getName());
    }
}

