/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ResultSetStream
implements ResultSet {
    ClosableIterator queryExecutionIter;
    List resultVars;
    QuerySolution currentEnv;
    int rowNumber;
    Model model;
    volatile boolean hasBeenClosed = false;

    public ResultSetStream(Query query2, ClosableIterator closableIterator) {
        this.queryExecutionIter = closableIterator;
        this.resultVars = query2.getResultVars();
        this.currentEnv = null;
        this.rowNumber = 0;
        this.model = query2.getQueryBlock().getDataSource().getModel();
    }

    public ResultSetStream(List list, ClosableIterator closableIterator) {
        this.queryExecutionIter = closableIterator;
        this.resultVars = list;
        this.currentEnv = null;
        this.rowNumber = 0;
        this.model = null;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    public boolean hasNext() {
        if (this.queryExecutionIter == null) {
            return false;
        }
        boolean bl = this.queryExecutionIter.hasNext();
        return bl;
    }

    public QuerySolution nextSolution() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        Binding binding = (Binding)this.queryExecutionIter.next();
        this.currentEnv = new ResultBinding(this.model, binding);
        if (this.currentEnv != null) {
            ++this.rowNumber;
        }
        return this.currentEnv;
    }

    public Object next() {
        return this.nextSolution();
    }

    public void close() {
        if (!this.hasBeenClosed) {
            if (this.queryExecutionIter != null) {
                this.queryExecutionIter.close();
            }
            this.hasBeenClosed = true;
        }
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List getResultVars() {
        return this.resultVars;
    }
}

