/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetTextFormatter;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class ResultSetMem
implements ResultSetRewindable {
    static final boolean DEBUG = false;
    List rows = new ArrayList();
    List varNames = null;
    int rowNumber = 0;
    Iterator iterator = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$query$core$ResultSetMem;

    public ResultSetMem(ResultSetMem resultSetMem) {
        this(resultSetMem, false);
    }

    public ResultSetMem(ResultSetMem resultSetMem, boolean bl) {
        this.varNames = resultSetMem.varNames;
        if (bl) {
            Iterator iterator = resultSetMem.rows.iterator();
            while (iterator.hasNext()) {
                this.rows.add((QuerySolution)iterator.next());
            }
        } else {
            this.rows = resultSetMem.rows;
        }
        this.reset();
    }

    public ResultSetMem(ResultSet resultSet) {
        if (resultSet instanceof ResultSetMem) {
            ResultSetMem resultSetMem = (ResultSetMem)resultSet;
            this.rows = resultSetMem.rows;
            this.varNames = resultSetMem.varNames;
        } else {
            this.varNames = resultSet.getResultVars();
            while (resultSet.hasNext()) {
                QuerySolution querySolution = resultSet.nextSolution();
                this.rows.add(querySolution);
            }
            resultSet.close();
        }
        this.reset();
    }

    public ResultSetMem(Model model) {
        this.buildFromDumpFormat(model);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass() + ": Attempt to remove an element");
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public QuerySolution nextSolution() {
        ++this.rowNumber;
        return (QuerySolution)this.iterator.next();
    }

    public Object next() {
        return this.nextSolution();
    }

    public void close() {
        this.iterator = null;
    }

    public void rewind() {
        this.reset();
    }

    public void reset() {
        this.iterator = this.rows.iterator();
        this.rowNumber = 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int size() {
        return this.rows.size();
    }

    public List getResultVars() {
        return this.varNames;
    }

    public List getAll() {
        return this.rows;
    }

    private void buildFromDumpFormat(Model model) {
        this.varNames = new ArrayList();
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)ResultSetVocab.ResultSet);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            StmtIterator stmtIterator2 = resource.listProperties(ResultSetVocab.resultVariable);
            while (stmtIterator2.hasNext()) {
                String string = stmtIterator2.nextStatement().getString();
                this.varNames.add(string);
            }
            stmtIterator2.close();
            int n = 0;
            StmtIterator stmtIterator3 = resource.listProperties(ResultSetVocab.solution);
            while (stmtIterator3.hasNext()) {
                Resource resource2 = stmtIterator3.nextStatement().getResource();
                ResultBinding resultBinding = new ResultBinding(resource2.getModel());
                ++n;
                StmtIterator stmtIterator4 = resource2.listProperties(ResultSetVocab.binding);
                while (stmtIterator4.hasNext()) {
                    Resource resource3 = stmtIterator4.nextStatement().getResource();
                    String string = resource3.getRequiredProperty(ResultSetVocab.variable).getString();
                    RDFNode rDFNode = resource3.getRequiredProperty(ResultSetVocab.value).getObject();
                    resultBinding.add(string, rDFNode);
                }
                stmtIterator4.close();
                this.rows.add(resultBinding);
            }
            stmtIterator3.close();
            if (resource.hasProperty(ResultSetVocab.size)) {
                try {
                    int n2 = resource.getRequiredProperty(ResultSetVocab.size).getInt();
                    if (n2 != n) {
                        LogFactory.getLog((Class)(class$com$hp$hpl$jena$query$core$ResultSetMem == null ? ResultSetMem.class$("com.hp.hpl.jena.query.core.ResultSetMem") : class$com$hp$hpl$jena$query$core$ResultSetMem)).warn((Object)("Warning: Declared size = " + n2 + " : Count = " + n));
                    }
                }
                catch (JenaException jenaException) {
                    // empty catch block
                }
            }
            stmtIterator.close();
        }
        this.reset();
    }

    public Model toModel() {
        Model model = ModelFactory.createDefaultModel();
        this.asRDF(model);
        return model;
    }

    public Resource asRDF(Model model) {
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(this, null);
        Resource resource = resultSetFormatter.asRDF(model);
        resultSetFormatter.close();
        return resource;
    }

    public void list(PrintWriter printWriter) {
        ResultSetMem resultSetMem = new ResultSetMem(this);
        ResultSetTextFormatter resultSetTextFormatter = new ResultSetTextFormatter(resultSetMem);
        resultSetTextFormatter.dump(printWriter, false);
        resultSetMem.close();
    }

    public void list(OutputStream outputStream) {
        ResultSetMem resultSetMem = new ResultSetMem(this);
        ResultSetTextFormatter resultSetTextFormatter = new ResultSetTextFormatter(resultSetMem);
        resultSetTextFormatter.dump(outputStream, false);
        resultSetMem.close();
    }
}

