/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RepeatApplyBinding
extends QueryIterator
implements ClosableIterator {
    static Log log = LogFactory.getLog((Class)RepeatApplyBinding.class);
    boolean finished = false;
    DataSource data;
    ClosableIterator nextStage = null;
    ClosableIterator input;
    GeneratorBinding generator;

    RepeatApplyBinding(Mark mark, DataSource dataSource, ClosableIterator closableIterator, GeneratorBinding generatorBinding) {
        super(mark);
        this.input = closableIterator;
        this.generator = generatorBinding;
        this.data = dataSource;
        if (this.input == null) {
            log.fatal((Object)"Repeated application to null input iterator");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Start"));
        }
    }

    public boolean hasNext() {
        if (this.finished) {
            if (LogHasNext && log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg("hasNext: Already finished"));
            }
            return false;
        }
        while (true) {
            if (this.nextStage == null) {
                this.nextStage = this.makeNextStage();
                if (this.nextStage == null) {
                    this.finished = true;
                    if (LogHasNext && log.isDebugEnabled()) {
                        log.debug((Object)this.mark.msg("hasNext: Finished/no next stage"));
                    }
                    this.close();
                    return false;
                }
            }
            if (this.nextStage.hasNext()) {
                if (LogHasNext && log.isDebugEnabled()) {
                    log.debug((Object)this.mark.msg("hasNext: => true"));
                }
                return true;
            }
            if (LogHasNext && log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg("hasNext: Stage iterator ends"));
            }
            this.nextStage.close();
            this.nextStage = null;
        }
    }

    public Object next() {
        if (this.finished) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg(".next: Already finished"));
            }
            throw new NoSuchElementException(this.getClass().getName() + ".next()/finished");
        }
        Object object = this.nextStage.next();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.mark.msg("next: " + object));
        }
        return object;
    }

    private ClosableIterator makeNextStage() {
        Mark mark = new Mark(this.mark);
        if (this.input == null || !this.input.hasNext()) {
            return null;
        }
        Binding binding = (Binding)this.input.next();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.mark.msg("New stage: Binding: " + binding));
        }
        ClosableIterator closableIterator = this.generator.makeIterator(mark, binding, this.data);
        return closableIterator;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.input != null) {
            this.input.close();
        }
    }

    static interface GeneratorBinding {
        public ClosableIterator makeIterator(Mark var1, Binding var2, DataSource var3);
    }
}

