/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementSource;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.ElementVisitor;
import java.util.ListIterator;

public abstract class RecursiveVisitor
implements ElementVisitor {
    public void startElement(ElementBasePattern elementBasePattern) {
    }

    public void endElement(ElementBasePattern elementBasePattern) {
    }

    public void startElement(ElementBlock elementBlock) {
    }

    public void endElement(ElementBlock elementBlock) {
    }

    public void startElement(ElementConstraints elementConstraints) {
    }

    public void endElement(ElementConstraints elementConstraints) {
    }

    public void startElement(ElementUnion elementUnion) {
    }

    public void endElement(ElementUnion elementUnion) {
    }

    public void startSubElement(ElementUnion elementUnion, Element element) {
    }

    public void endSubElement(ElementUnion elementUnion, Element element) {
    }

    public void startElement(ElementGroup elementGroup) {
    }

    public void endElement(ElementGroup elementGroup) {
    }

    public void startSubElement(ElementGroup elementGroup, Element element) {
    }

    public void endSubElement(ElementGroup elementGroup, Element element) {
    }

    public void startElement(ElementOptional elementOptional) {
    }

    public void endElement(ElementOptional elementOptional) {
    }

    public void startElement(ElementSource elementSource) {
    }

    public void endElement(ElementSource elementSource) {
    }

    public void startElement(ElementUnsaid elementUnsaid) {
    }

    public void endElement(ElementUnsaid elementUnsaid) {
    }

    public void visit(ElementBasePattern elementBasePattern) {
        this.startElement(elementBasePattern);
        this.endElement(elementBasePattern);
    }

    public void visit(ElementBlock elementBlock) {
        this.startElement(elementBlock);
        ((Element)elementBlock.queryElement).visit(this);
        this.endElement(elementBlock);
    }

    public void visit(ElementConstraints elementConstraints) {
        this.startElement(elementConstraints);
        this.endElement(elementConstraints);
    }

    public void visit(ElementUnion elementUnion) {
        this.startElement(elementUnion);
        ListIterator listIterator = elementUnion.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            this.startSubElement(elementUnion, element);
            element.visit(this);
            this.endSubElement(elementUnion, element);
        }
        this.endElement(elementUnion);
    }

    public void visit(ElementGroup elementGroup) {
        this.startElement(elementGroup);
        ListIterator listIterator = elementGroup.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            this.startSubElement(elementGroup, element);
            element.visit(this);
            this.endSubElement(elementGroup, element);
        }
        this.endElement(elementGroup);
    }

    public void visit(ElementOptional elementOptional) {
        this.startElement(elementOptional);
        elementOptional.element.visit(this);
        this.endElement(elementOptional);
    }

    public void visit(ElementSource elementSource) {
        this.startElement(elementSource);
        elementSource.element.visit(this);
        this.endElement(elementSource);
    }

    public void visit(ElementUnsaid elementUnsaid) {
        this.startElement(elementUnsaid);
        elementUnsaid.element.visit(this);
        this.endElement(elementUnsaid);
    }
}

