/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngineUtils {
    static Log log = LogFactory.getLog((Class)QueryEngineUtils.class);

    static void compilePattern(com.hp.hpl.jena.graph.query.Query query2, List list, Binding binding, Set set) {
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            if ((triple = QueryEngineUtils.substituteIntoTriple(triple, binding)).getSubject().isVariable()) {
                set.add(triple.getSubject());
            }
            if (triple.getPredicate().isVariable()) {
                set.add(triple.getPredicate());
            }
            if (triple.getObject().isVariable()) {
                set.add(triple.getObject());
            }
            query2.addMatch(triple);
        }
    }

    static void compileConstraints(com.hp.hpl.jena.graph.query.Query query2, List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            if (constraint instanceof Expression) {
                Expression expression = (Expression)constraint;
                query2.addConstraint(expression);
                continue;
            }
            log.warn((Object)("Query constraint '" + constraint + "' is not an expression"));
        }
    }

    static RDFNode convertGraphNodeToRDFNode(Node node, Model model) {
        if (node.isLiteral()) {
            return new LiteralImpl(node, (ModelCom)model);
        }
        if (node.isURI() || node.isBlank()) {
            return new ResourceImpl(node, (ModelCom)model);
        }
        if (node.isVariable()) {
            throw new QueryException("Variable unbound: " + node);
        }
        log.warn((Object)("Unknown node type for node: " + node));
        return null;
    }

    static Triple substituteIntoTriple(Triple triple, Binding binding) {
        Node node = QueryEngineUtils.substituteNode(triple.getSubject(), binding);
        Node node2 = QueryEngineUtils.substituteNode(triple.getPredicate(), binding);
        Node node3 = QueryEngineUtils.substituteNode(triple.getObject(), binding);
        if (node == triple.getSubject() && node2 == triple.getPredicate() && node3 == triple.getObject()) {
            return triple;
        }
        return new Triple(node, node2, node3);
    }

    static Node substituteNode(Node node, Binding binding) {
        if (!node.isVariable()) {
            return node;
        }
        String string = ((Node_Variable)node).getName();
        Object object = null;
        if (binding != null) {
            object = binding.get(string);
        }
        if (object == null) {
            return node;
        }
        if (object instanceof Node) {
            return (Node)object;
        }
        log.warn((Object)("Unknown object in binding: ignored: " + object.getClass().getName()));
        return node;
    }

    static Node[] projectionVars(Set set) {
        Node[] nodeArray = new Node[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Node node;
            nodeArray[n] = node = (Node)iterator.next();
            ++n;
        }
        return nodeArray;
    }

    static String fmtExpression(Expression expression) {
        return QueryEngineUtils.fmtExpression(new StringBuffer(), expression).toString();
    }

    static StringBuffer fmtExpression(StringBuffer stringBuffer, Expression expression) {
        stringBuffer.append("Expression: " + expression + "  [" + expression.getClass().getName() + "]");
        if (expression.isApply()) {
            System.out.println("  Apply - " + expression.getFun());
            for (int i = 0; i < expression.argCount(); ++i) {
                QueryEngineUtils.fmtExpression(stringBuffer, expression.getArg(i));
            }
        } else if (expression.isVariable()) {
            stringBuffer.append("  Variable - " + expression.getName());
        } else if (expression.isConstant()) {
            stringBuffer.append("  Constant - " + expression.getValue());
        } else {
            stringBuffer.append("  Unknown");
        }
        return stringBuffer;
    }

    public static Collection getTriples(ResultBinding resultBinding, Query query2) {
        HashSet hashSet = new HashSet();
        QueryEngineUtils.getStatements(resultBinding, query2.getQueryBlock(), hashSet);
        return hashSet;
    }

    static void getStatements(ResultBinding resultBinding, ElementBlock elementBlock, Collection collection) {
        Model model = resultBinding.getModel();
        if (elementBlock.getQueryElement() != null) {
            HashSet hashSet = new HashSet();
            elementBlock.getQueryElement().subst(hashSet, resultBinding.getBinding());
            try {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Triple triple = (Triple)iterator.next();
                    RDFNode rDFNode = QueryEngineUtils.convertGraphNodeToRDFNode(triple.getSubject(), model);
                    RDFNode rDFNode2 = QueryEngineUtils.convertGraphNodeToRDFNode(triple.getPredicate(), model);
                    if (rDFNode2 instanceof Resource) {
                        rDFNode2 = model.createProperty(((Resource)rDFNode2).getURI());
                    }
                    RDFNode rDFNode3 = QueryEngineUtils.convertGraphNodeToRDFNode(triple.getObject(), model);
                    Statement statement = model.createStatement((Resource)rDFNode, (Property)rDFNode2, rDFNode3);
                    collection.add(statement);
                }
            }
            catch (Exception exception) {
                LogFactory.getLog((Class)ResultBinding.class).warn((Object)("ResultBindingImpl.getTriples: Substitution error: " + exception));
            }
        }
    }

    public static Model mergeTriples(Model model, ResultBinding resultBinding, Query query2) {
        Collection collection = QueryEngineUtils.getTriples(resultBinding, query2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            model.add((Statement)iterator.next());
        }
        return model;
    }
}

