/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSourceFactory;
import com.hp.hpl.jena.query.DescribeBNodeClosure;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingImmutable;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.DataSourceNamedGroup;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.ResultSetStream;
import com.hp.hpl.jena.query.util.ClosableFilterIterator;
import com.hp.hpl.jena.query.util.ClosableIteratorDistinct;
import com.hp.hpl.jena.query.util.ClosableIteratorLimit;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngine
implements QueryExecution {
    static Log log = LogFactory.getLog((Class)QueryEngine.class);
    Query query;
    static int queryCount = 0;
    boolean queryInitialised = false;
    int idQueryExecution;
    ClosableIterator resultsIter;
    QuerySolution startBinding = null;
    FileManager fileManager = FileManager.get();

    public QueryEngine(Query query2) {
        this.query = query2;
        this.idQueryExecution = ++queryCount;
    }

    public void init() {
        if (this.queryInitialised) {
            return;
        }
        if (this.query.getQueryBlock() == null || this.query.getQueryBlock().getDataSource() == null) {
            if (!(this.query.getSourceURIs() != null && this.query.getSourceURIs().size() != 0 || this.query.getNamedSourceURIs() != null && this.query.getNamedSourceURIs().size() != 0)) {
                throw new QueryException("No model for query");
            }
            DataSourceNamedGroup dataSourceNamedGroup = DataSourceFactory.create(this.query.getSourceURIs(), this.query.getNamedSourceURIs(), this.fileManager, this.query.getBaseURI());
            if (this.query.getQueryBlock() != null) {
                this.query.getQueryBlock().setDataSource(dataSourceNamedGroup);
            } else {
                this.query.setQueryBlock(new ElementBlock(dataSourceNamedGroup, null));
            }
        } else {
            log.debug((Object)"External data source for query");
        }
        this.queryInitialised = true;
    }

    public void setInitialBinding(QuerySolution querySolution) {
        this.startBinding = querySolution;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public Model execConstruct() {
        Object object;
        this.init();
        if (!this.query.isConstructType()) {
            throw new QueryException("Attempt to get a CONSTRUCT model from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model model = ModelFactory.createDefaultModel();
        this.insertPrefixesInto(model);
        model.setNsPrefixes((PrefixMapping)this.query.getQueryBlock().getDataSource().getModel());
        ResultSet resultSet = this.execInternal();
        HashSet hashSet = new HashSet();
        while (resultSet.hasNext()) {
            object = (ResultBinding)resultSet.nextSolution();
            ElementBlock elementBlock = new ElementBlock(this.query.getQueryBlock().getDataSource(), this.query.getConstructPattern());
            QueryEngineUtils.getStatements((ResultBinding)object, elementBlock, hashSet);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            model.add((Statement)object.next());
        }
        return model;
    }

    public Model execDescribe() {
        RDFNode rDFNode;
        String string;
        Object object;
        Object object2;
        this.init();
        if (!this.query.isDescribeType()) {
            throw new QueryException("Attempt to get a DESCRIBE result from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        Model model = ModelFactory.createDefaultModel();
        this.insertPrefixesInto(model);
        model.setNsPrefixes((PrefixMapping)this.query.getQueryBlock().getDataSource().getModel());
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        ResultSet resultSet = this.execInternal();
        while (resultSet.hasNext()) {
            object2 = resultSet.nextSolution();
            object = this.query.getResultVars().iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                rDFNode = object2.get(string);
                hashSet.add(rDFNode);
            }
        }
        object2 = this.query.getResultURIs().iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            string = this.query.getQueryBlock().getDataSource().getModel();
            rDFNode = QueryEngineUtils.convertGraphNodeToRDFNode((Node)object, (Model)string);
            hashSet.add(rDFNode);
        }
        object2 = new DescribeBNodeClosure();
        object = hashSet.iterator();
        while (object.hasNext()) {
            string = (RDFNode)object.next();
            if (!(string instanceof Resource)) continue;
            object2.describe(model, (Resource)string);
        }
        return model;
    }

    public ResultSet execSelect() {
        this.init();
        if (!this.query.isSelectType()) {
            throw new QueryException("Attempt to have ResultSet from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        return this.execInternal();
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryException("Attempt to have boolean from a " + QueryEngine.labelForQuery(this.query) + " query");
        }
        ResultSet resultSet = this.execInternal();
        boolean bl = resultSet.hasNext();
        resultSet.close();
        return bl;
    }

    private ResultSet execInternal() {
        this.resultsIter = null;
        try {
            this.init();
            ElementBlock elementBlock = this.query.getQueryBlock();
            if (elementBlock == null) {
                new ResultSetStream(this.query, (ClosableIterator)new NullIterator());
            }
            SingletonIterator singletonIterator = new SingletonIterator((Object)Binding.START);
            if (this.startBinding != null) {
                Binding binding = null;
                if (this.startBinding instanceof ResultBinding) {
                    binding = ((ResultBinding)this.startBinding).getBinding();
                } else {
                    binding = new BindingMap();
                    Iterator iterator = this.startBinding.varNames();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        RDFNode rDFNode = this.startBinding.get(string);
                        binding.add(string, rDFNode.asNode());
                    }
                }
                singletonIterator = new SingletonIterator((Object)binding);
            }
            this.resultsIter = elementBlock.exec(new Mark(), (ClosableIterator)singletonIterator);
            this.resultsIter = new ClosableFilterIterator(Binding.filter, this.resultsIter);
            if (this.query.isDistinct()) {
                this.resultsIter = BindingImmutable.makeConverterIterator(this.query.getResultVars(), this.resultsIter);
                this.resultsIter = new ClosableIteratorDistinct(this.resultsIter);
            }
            if (this.query.getLimit() != Query.NOLIMIT) {
                this.resultsIter = new ClosableIteratorLimit(this.resultsIter, this.query.getLimit());
            }
            return new ResultSetStream(this.query, this.resultsIter);
        }
        catch (RuntimeException runtimeException) {
            if (this.resultsIter != null) {
                this.resultsIter.close();
            }
            throw runtimeException;
        }
    }

    public void abort() {
        this.resultsIter.close();
    }

    public void close() {
        if (this.resultsIter != null) {
            this.resultsIter.close();
            this.resultsIter = null;
        }
    }

    private void insertPrefixesInto(Model model) {
        try {
            Model model2 = this.query.getQueryBlock().getDataSource().getModel();
            model.setNsPrefixes((PrefixMapping)model2);
            model.setNsPrefixes(this.query.getLocalPrefixMap());
        }
        catch (Exception exception) {
            log.warn((Object)("Exception in insertPrefixes: " + exception.getMessage()));
        }
    }

    private static String labelForQuery(Query query2) {
        if (query2.isSelectType()) {
            return "SELECT";
        }
        if (query2.isConstructType()) {
            return "CONSTRUCT";
        }
        if (query2.isDescribeType()) {
            return "DESCRIBE";
        }
        if (query2.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }
}

