/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementFormatter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementSource;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterPlain
extends ElementFormatter {
    static final int INDENT = 2;
    static final boolean allowDoubles = true;

    public void format(IndentedLineBuffer indentedLineBuffer, Query query2, Element element) {
        this.query = query2;
        this.buff = indentedLineBuffer;
        element.visit(this);
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.formatTriple(elementTriplePattern.getTriple());
        this.buff.newline();
    }

    public void visit(ElementBasePattern elementBasePattern) {
        this.buff.append("BasePattern");
        this.buff.newline();
        this.buff.incIndent(2);
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
            this.buff.newline();
        }
        this.buff.decIndent(2);
    }

    private void formatTriple(Triple triple) {
        String string = FormatterPlain.triplePatternToString(this.query, triple);
        this.buff.append(string);
    }

    public void visit(ElementBlock elementBlock) {
        this.buff.append("Block");
        this.buff.newline();
        this.buff.incIndent(2);
        if (elementBlock.dataSource != null) {
            this.buff.append("Source");
        }
        ((Element)elementBlock.queryElement).visit(this);
        this.buff.decIndent(2);
    }

    public void visit(ElementConstraints elementConstraints) {
        this.buff.append("Constraint");
        this.buff.newline();
        this.buff.incIndent(2);
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            this.buff.append(constraint.toString());
            this.buff.newline();
        }
        this.buff.decIndent(2);
    }

    public void visit(ElementUnion elementUnion) {
        this.buff.append("Union");
        this.buff.newline();
        this.buff.incIndent(2);
        ListIterator listIterator = elementUnion.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            element.visit(this);
        }
        this.buff.decIndent(2);
    }

    public void visit(ElementGroup elementGroup) {
        this.buff.append("Group");
        this.buff.incIndent(2);
        this.buff.newline();
        ListIterator listIterator = elementGroup.elements.listIterator();
        while (listIterator.hasNext()) {
            Element element = (Element)listIterator.next();
            element.visit(this);
        }
        this.buff.decIndent(2);
    }

    public void visit(ElementOptional elementOptional) {
    }

    public void visit(ElementSource elementSource) {
    }

    public void visit(ElementUnsaid elementUnsaid) {
    }

    private static String triplePatternToString(Query query2, Triple triple) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FormatterPlain.slotToString(query2, triple.getSubject()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterPlain.slotToString(query2, triple.getPredicate()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterPlain.slotToString(query2, triple.getObject()));
        return stringBuffer.toString();
    }

    private static String slotToString(Query query2, Node node) {
        return QueryPrintUtils.stringForNode(node, query2.getPrefixMap());
    }
}

