/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.DataSourceNamedGroup;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementFormatter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementSource;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterARQ
extends ElementFormatter {
    static final int INDENT = 2;
    static final boolean allowDoubles = true;
    public static boolean PATTERN_MARKERS = false;
    public static boolean PATTERN_FINAL_DOT = false;
    public static boolean UNION_MARKERS = false;
    public static boolean GROUP_UNNEST_ONE = false;
    public static boolean OPTIONAL_MARKERS = false;
    public static boolean SOURCE_FIXED_INDENT = true;
    public static boolean UNSAID_FIXED_INDENT = true;

    public void format(IndentedLineBuffer indentedLineBuffer, Query query2, Element element) {
        this.query = query2;
        this.buff = indentedLineBuffer;
        element.visit(this);
    }

    static String asString(Query query2, Element element) {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterARQ formatterARQ = new FormatterARQ();
        formatterARQ.format(indentedLineBuffer, query2, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.formatTriple(elementTriplePattern.getTriple(), false);
        this.buff.append(" /*$$*/");
    }

    public void visit(ElementBasePattern elementBasePattern) {
        boolean bl = true;
        if (PATTERN_MARKERS) {
            this.buff.append("| ");
            this.buff.incIndent(2);
        }
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            if (!bl) {
                if (!PATTERN_FINAL_DOT) {
                    this.buff.append(". ");
                }
                this.buff.newline();
            }
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple, PATTERN_FINAL_DOT);
            bl = false;
        }
        if (PATTERN_MARKERS) {
            this.buff.decIndent(2);
            this.buff.append(" | ");
        }
    }

    private void formatTriple(Triple triple, boolean bl) {
        this.buff.append(FormatterARQ.triplePatternToString(this.query, triple));
        if (bl) {
            this.buff.append(" . ");
        } else {
            this.buff.append(" ");
        }
    }

    public void visit(ElementBlock elementBlock) {
        DataSourceNamedGroup dataSourceNamedGroup;
        Iterator iterator;
        if (elementBlock.getDataSource() != null && elementBlock.getDataSource() instanceof DataSourceNamedGroup && (iterator = (dataSourceNamedGroup = (DataSourceNamedGroup)elementBlock.getDataSource()).listModelLabels()).hasNext()) {
            this.buff.append("FROM");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.buff.append(" ");
                this.buff.append(string);
            }
            this.buff.newline();
        }
        if (elementBlock.queryElement != null) {
            ((Element)elementBlock.queryElement).visit(this);
        }
    }

    public void visit(ElementConstraints elementConstraints) {
        boolean bl = true;
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            if (!bl) {
                this.buff.append(" . ");
            }
            Constraint constraint = (Constraint)iterator.next();
            this.buff.append(constraint.toString());
            bl = false;
        }
    }

    public void visit(ElementUnion elementUnion) {
        if (elementUnion.elements.size() == 1) {
            Element element = (Element)elementUnion.elements.get(0);
            element.visit(this);
            return;
        }
        if (UNION_MARKERS) {
            this.buff.append("{");
            this.buff.incIndent(2);
            this.buff.pad();
        }
        boolean bl = true;
        ListIterator listIterator = elementUnion.elements.listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.buff.newline();
                this.buff.append("OR");
                this.buff.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
        }
        if (UNION_MARKERS) {
            this.buff.decIndent(2);
            this.buff.newline();
            this.buff.append("}");
        }
    }

    public void visit(ElementGroup elementGroup) {
        if (GROUP_UNNEST_ONE && elementGroup.elements.size() == 1) {
            Element element = (Element)elementGroup.elements.get(0);
            element.visit(this);
            return;
        }
        this.buff.append("{");
        this.buff.incIndent(2);
        int n = this.buff.getRow();
        this.buff.pad();
        boolean bl = true;
        boolean bl2 = false;
        ListIterator listIterator = elementGroup.elements.listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                if (bl2) {
                    this.buff.append(". ");
                }
                this.buff.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
            bl2 = false;
            if (element instanceof ElementBasePattern) {
                bl2 = !PATTERN_FINAL_DOT;
                continue;
            }
            this.buff.append(" . ");
            bl2 = false;
        }
        this.buff.decIndent(2);
        int n2 = this.buff.getRow();
        if (n != n2) {
            this.buff.newline();
        }
        this.buff.append("}");
    }

    public void visit(ElementOptional elementOptional) {
        this.buff.append("OPTIONAL");
        this.buff.incIndent(2);
        this.buff.newline();
        if (OPTIONAL_MARKERS) {
            this.buff.append("{");
            this.buff.incIndent(2);
        }
        this.buff.pad();
        elementOptional.element.visit(this);
        if (OPTIONAL_MARKERS) {
            this.buff.append("}");
            this.buff.decIndent(2);
        }
        this.buff.decIndent(2);
    }

    public void visit(ElementSource elementSource) {
        String string = "SOURCE ";
        int n = string.length();
        this.buff.append(string);
        string = elementSource.sourceNode == null ? "*" : FormatterARQ.slotToString(this.query, elementSource.sourceNode);
        this.buff.append(string);
        n += string.length();
        if (SOURCE_FIXED_INDENT) {
            this.buff.incIndent(2);
            this.buff.newline();
        } else {
            this.buff.append(" ");
            this.buff.incIndent(++n);
        }
        elementSource.element.visit(this);
        if (SOURCE_FIXED_INDENT) {
            this.buff.decIndent(2);
        } else {
            this.buff.decIndent(n);
        }
    }

    public void visit(ElementUnsaid elementUnsaid) {
        String string = "UNSAID ";
        int n = string.length();
        this.buff.append(string);
        n += string.length();
        if (UNSAID_FIXED_INDENT) {
            this.buff.incIndent(2);
            this.buff.newline();
        } else {
            this.buff.append(" ");
            this.buff.incIndent(++n);
        }
        elementUnsaid.element.visit(this);
        if (UNSAID_FIXED_INDENT) {
            this.buff.decIndent(2);
        } else {
            this.buff.decIndent(n);
        }
    }

    private static String triplePatternToString(Query query2, Triple triple) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FormatterARQ.slotToString(query2, triple.getSubject()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterARQ.slotToString(query2, triple.getPredicate()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterARQ.slotToString(query2, triple.getObject()));
        return stringBuffer.toString();
    }

    private static String slotToString(Query query2, Node node) {
        return QueryPrintUtils.stringForNode(node, query2.getPrefixMap());
    }
}

