/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.util.ClosableNullIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementTriplePattern
extends Element {
    static Log log = LogFactory.getLog((Class)ElementTriplePattern.class);
    Triple triple = null;
    Node[] projectionVars = null;

    public void setTriple(Triple triple) {
        this.triple = triple;
    }

    public Triple getTriple() {
        return this.triple;
    }

    public ClosableIterator exec(Mark mark, ClosableIterator closableIterator, DataSource dataSource) {
        if (this.triple == null) {
            log.warn((Object)"Triple is null");
            return new ClosableNullIterator();
        }
        ElementBasePattern elementBasePattern = new ElementBasePattern();
        elementBasePattern.addTriple(this.triple);
        return elementBasePattern.exec(mark, closableIterator, dataSource);
    }

    protected void varsRequired(Set set) {
    }

    protected void varsBound(Set set) {
        this.addVar(set, this.triple.getSubject());
        this.addVar(set, this.triple.getPredicate());
        this.addVar(set, this.triple.getObject());
    }

    private void addVar(Set set, Node node) {
        if (node.isVariable()) {
            set.add(node.getName());
        }
    }

    public void subst(Collection collection, Binding binding) {
        Triple triple = QueryEngineUtils.substituteIntoTriple(this.triple, binding);
        collection.add(triple);
    }

    protected void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2() {
    }
}

