/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Binding0;
import com.hp.hpl.jena.query.core.DataSourceNamedGroup;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.RepeatApplyBinding;
import com.hp.hpl.jena.query.core.SourceIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementSource
extends Element
implements RepeatApplyBinding.GeneratorBinding {
    static Log log = LogFactory.getLog((Class)ElementSource.class);
    Element element;
    Node sourceNode;

    public ElementSource(Element element) {
        this.element = element;
        this.sourceNode = null;
    }

    public ElementSource(Node node, Element element) {
        this.element = element;
        this.sourceNode = node;
    }

    public ClosableIterator exec(Mark mark, ClosableIterator closableIterator, DataSource dataSource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Source: " + this.element));
        }
        Mark mark2 = new Mark(mark);
        mark2.incDepth();
        if (!dataSource.isAggregate()) {
            if (this.sourceNode == null || this.sourceNode.isVariable()) {
                return this.element.exec(mark2, closableIterator, dataSource);
            }
            return null;
        }
        if (closableIterator == null) {
            return new SourceIterator(mark2, new Binding0(), (DataSourceNamedGroup)dataSource, this);
        }
        return new RepeatApplyBinding(mark2, dataSource, closableIterator, this);
    }

    public ClosableIterator makeIterator(Mark mark, Binding binding, DataSource dataSource) {
        if (!dataSource.isAggregate()) {
            throw new ARQInternalErrorException("DataSource is not an aggregate");
        }
        if (!(dataSource instanceof DataSourceNamedGroup)) {
            throw new ARQInternalErrorException("DataSource is not a DataSourceNamedGroup");
        }
        return new SourceIterator(mark, binding, (DataSourceNamedGroup)dataSource, this);
    }

    protected void varsRequired(Set set) {
        this.element.varsRequired(set);
    }

    protected void varsBound(Set set) {
        if (this.sourceNode != null && this.sourceNode.isVariable()) {
            set.add(this.sourceNode.getName());
        }
        this.element.varsBound(set);
    }

    public void subst(Collection collection, Binding binding) {
        this.element.subst(collection, binding);
    }

    protected void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2() {
        if (this.element != null) {
            this.element.phase2();
        }
    }
}

