/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.RepeatApplyBinding;
import com.hp.hpl.jena.query.util.ClosableDefaultingIterator;
import com.hp.hpl.jena.query.util.ClosableFirstElementIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementOptional
extends Element {
    static Log log = LogFactory.getLog((Class)ElementOptional.class);
    Element element;

    public ElementOptional(Element element) {
        this.element = element;
    }

    public ClosableIterator exec(Mark mark, ClosableIterator closableIterator, DataSource dataSource) {
        if (closableIterator == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("Optional/no input"));
            }
            ClosableIterator closableIterator2 = this.element.exec(mark, null, dataSource);
            if (ARQ.doNiceOptionals) {
                return new ClosableDefaultingIterator(closableIterator2, null);
            }
            return new ClosableFirstElementIterator(null, closableIterator2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Optional"));
        }
        Mark mark2 = new Mark(mark);
        RepeatApplyBinding repeatApplyBinding = new RepeatApplyBinding(mark2, dataSource, closableIterator, new Generator(this.element, mark));
        return repeatApplyBinding;
    }

    protected void varsRequired(Set set) {
        this.element.varsRequired(set);
    }

    protected void varsBound(Set set) {
        this.element.varsBound(set);
    }

    public void subst(Collection collection, Binding binding) {
        this.element.subst(collection, binding);
    }

    protected void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2() {
        if (this.element != null) {
            this.element.phase2();
        }
    }

    static class FirstBinding
    implements ClosableFirstElementIterator.DoFirst {
        Binding binding;

        FirstBinding(Binding binding) {
            this.binding = binding;
        }

        public boolean hasFirstElement(ClosableIterator closableIterator) {
            return this.binding != null;
        }

        public Object firstElement(ClosableIterator closableIterator) {
            return this.binding;
        }
    }

    static class Generator
    implements RepeatApplyBinding.GeneratorBinding {
        Mark mark;
        Element element;

        Generator(Element element, Mark mark) {
            this.element = element;
            this.mark = mark;
        }

        public ClosableIterator makeIterator(Mark mark, Binding binding, DataSource dataSource) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg(mark + " makeIterator: " + binding));
            }
            ClosableIterator closableIterator = this.element.exec(mark, (ClosableIterator)new SingletonIterator((Object)binding), dataSource);
            if (ARQ.doNiceOptionals) {
                return new ClosableDefaultingIterator(closableIterator, binding);
            }
            return new ClosableFirstElementIterator(new FirstBinding(binding), closableIterator);
        }
    }
}

