/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.util.ListUtils;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementGroup
extends Element {
    static Log log = LogFactory.getLog((Class)ElementGroup.class);
    List elements = new ArrayList();

    Iterator elements() {
        return this.elements.listIterator();
    }

    public void addElement(QueryElement queryElement) {
        this.elements.add(queryElement);
    }

    public ClosableIterator exec(Mark mark, ClosableIterator closableIterator, DataSource dataSource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Group: " + this.elements.size() + " elements"));
        }
        if (this.elements.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("exec: Empty group"));
            }
            return closableIterator;
        }
        if (this.elements.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("  exec: Only one element in group"));
            }
            QueryElement queryElement = (QueryElement)this.elements.get(0);
            Mark mark2 = new Mark(mark);
            mark2.incDepth();
            return queryElement.exec(mark2, closableIterator, dataSource);
        }
        int n = 0;
        int n2 = mark.getDepth() + 1;
        ListIterator listIterator = this.elements.listIterator();
        ClosableIterator closableIterator2 = closableIterator;
        while (listIterator.hasNext()) {
            ClosableIterator closableIterator3;
            QueryElement queryElement = (QueryElement)listIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("[" + n + "] create element iterator"));
            }
            Mark mark3 = new Mark(n2, n);
            closableIterator2 = closableIterator3 = queryElement.exec(mark3, closableIterator2, dataSource);
            ++n;
        }
        return closableIterator2;
    }

    public void phase2() {
        boolean bl = false;
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.phase2();
            if (!(element instanceof ElementTriplePattern)) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.compressTriplePatterns();
        ListUtils.removeNulls(this.elements);
    }

    private void compressTriplePatterns() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element;
            int n;
            Element element2 = (Element)this.elements.get(i);
            if (!(element2 instanceof ElementTriplePattern)) continue;
            ElementTriplePattern elementTriplePattern = (ElementTriplePattern)element2;
            ElementBasePattern elementBasePattern = new ElementBasePattern();
            elementBasePattern.addTriple(elementTriplePattern.getTriple());
            this.elements.set(i, elementBasePattern);
            for (n = i + 1; n < this.elements.size() && (element = (Element)this.elements.get(n)) instanceof ElementTriplePattern; ++n) {
                ElementTriplePattern elementTriplePattern2 = (ElementTriplePattern)element;
                elementBasePattern.addTriple(elementTriplePattern2.getTriple());
                this.elements.set(n, null);
            }
            i = n;
        }
    }

    protected void varsRequired(Set set) {
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.varsRequired(set);
        }
    }

    protected void varsBound(Set set) {
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.varsBound(set);
        }
    }

    public void subst(Collection collection, Binding binding) {
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.subst(collection, binding);
        }
    }

    protected void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }
}

