/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Collection;
import java.util.Set;

public class ElementBlock
extends Element {
    DataSource dataSource = null;
    QueryElement queryElement = null;

    public ElementBlock(DataSource dataSource, QueryElement queryElement) {
        this.dataSource = dataSource;
        this.queryElement = queryElement;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public void setQueryElement(QueryElement queryElement) {
        this.queryElement = queryElement;
    }

    public ClosableIterator exec(Mark mark, ClosableIterator closableIterator) {
        if (this.dataSource == null) {
            throw new QueryException("QueryBlock: no data source");
        }
        if (this.queryElement == null) {
            return new NullIterator();
        }
        return this.queryElement.exec(mark, closableIterator, this.dataSource);
    }

    public ClosableIterator exec(Mark mark, ClosableIterator closableIterator, DataSource dataSource) {
        if (this.dataSource != null) {
            dataSource = this.dataSource;
        }
        return this.queryElement.exec(mark, closableIterator, dataSource);
    }

    protected void varsRequired(Set set) {
        if (this.queryElement != null) {
            if (this.queryElement instanceof Element) {
                ((Element)this.queryElement).varsRequired(set);
            } else {
                set.addAll(this.queryElement.varsRequired());
            }
        }
    }

    protected void varsBound(Set set) {
        if (this.queryElement != null) {
            if (this.queryElement instanceof Element) {
                ((Element)this.queryElement).varsBound(set);
            } else {
                set.addAll(this.queryElement.varsBound());
            }
        }
    }

    public void subst(Collection collection, Binding binding) {
        if (this.queryElement != null) {
            this.queryElement.subst(collection, binding);
        }
    }

    protected void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2() {
        if (this.queryElement != null) {
            this.queryElement.phase2();
        }
    }
}

