/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.FormatterARQ;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class Element
implements QueryElement {
    protected abstract void varsRequired(Set var1);

    public Set varsRequired() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.varsRequired(linkedHashSet);
        return linkedHashSet;
    }

    protected abstract void varsBound(Set var1);

    public Set varsBound() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.varsBound(linkedHashSet);
        return linkedHashSet;
    }

    public abstract void subst(Collection var1, Binding var2);

    protected abstract void visit(ElementVisitor var1);

    public void output(Query query2, OutputStream outputStream) {
        Writer writer = FileUtils.asUTF8((OutputStream)outputStream);
        this.output(query2, writer);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void output(Query query2, Writer writer) {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterARQ.asString(query2, this);
        try {
            writer.write(indentedLineBuffer.getBuffer().toString());
            writer.flush();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    public String toString() {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterARQ.asString(null, this);
        return indentedLineBuffer.toString();
    }

    public abstract void phase2();
}

